/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce;

import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;

public class SqmCreationHelper {
    public static NavigablePath buildRootNavigablePath(String base, String alias) {
        return alias == null ? new NavigablePath(base) : new NavigablePath(base + '(' + alias + ')');
    }

    public static NavigablePath buildSubNavigablePath(NavigablePath lhs, String base, String alias) {
        String localPath = alias == null ? base : base + '(' + alias + ')';
        return lhs.append(localPath);
    }

    private SqmCreationHelper() {
    }

    public static void resolveAsLhs(SqmPath lhs, SqmPath processingPath, Navigable subNavigable, boolean isSubRefTerminal, SqmCreationState creationState) {
        SqmFrom lhsFrom;
        if (lhs == null) {
            return;
        }
        SqmCreationProcessingState processingState = creationState.getProcessingStateStack().getCurrent();
        if (lhs instanceof SqmFrom) {
            lhsFrom = (SqmFrom)lhs;
        } else {
            lhs.prepareForSubNavigableReference(processingPath.getReferencedNavigable(), false, creationState);
            lhsFrom = processingState.getPathRegistry().findFromByPath(lhs.getNavigablePath());
        }
        if (subNavigable instanceof EntityIdentifier && isSubRefTerminal) {
            return;
        }
        SqmFrom existingJoin = processingState.getPathRegistry().findFromByPath(processingPath.getNavigablePath());
        if (existingJoin == null) {
            SqmNavigableJoin sqmJoin = new SqmNavigableJoin(lhsFrom, (Joinable)processingPath.getReferencedNavigable(), null, SqmJoinType.INNER, false, creationState);
            lhsFrom.addJoin(sqmJoin);
            processingState.getPathRegistry().register(sqmJoin);
        }
    }
}

