/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.SqmProductionException;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.AbstractSqmFunctionTemplate;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmJdbcFunctionEscapeWrapper;

public class JdbcFunctionEscapeWrapperTemplate
extends AbstractSqmFunctionTemplate {
    private final SqmFunctionTemplate wrapped;

    public JdbcFunctionEscapeWrapperTemplate(SqmFunctionTemplate wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        SqmExpression wrappedSqmExpression = this.wrapped.makeSqmFunctionExpression(arguments, impliedResultType);
        if (!SqmFunction.class.isInstance(wrappedSqmExpression)) {
            throw new SqmProductionException(String.format(Locale.ROOT, "Expected expression to wrap in a JDBC escape wrapper to be a %s, but was %s", SqmFunction.class.getName(), wrappedSqmExpression.asLoggableText()));
        }
        return new SqmJdbcFunctionEscapeWrapper((SqmFunction)wrappedSqmExpression);
    }
}

