/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.spi.NamedSqmFunctionTemplate;
import org.jboss.logging.Logger;

public class NamedFunctionTemplateBuilder {
    private static final Logger log = Logger.getLogger(NamedFunctionTemplateBuilder.class);
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final String functionName;
    private ArgumentsValidator argumentsValidator;
    private FunctionReturnTypeResolver returnTypeResolver;
    private boolean useParenthesesWhenNoArgs;

    public NamedFunctionTemplateBuilder(SqmFunctionRegistry registry, String functionName) {
        this.registry = registry;
        this.registrationKey = functionName;
        this.functionName = functionName;
    }

    public NamedFunctionTemplateBuilder(SqmFunctionRegistry registry, String registrationKey, String functionName) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.functionName = functionName;
    }

    public NamedFunctionTemplateBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public NamedFunctionTemplateBuilder setArgumentCountBetween(int min, int max) {
        return this.setArgumentsValidator(StandardArgumentsValidators.between(min, max));
    }

    public NamedFunctionTemplateBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public NamedFunctionTemplateBuilder setReturnTypeResolver(FunctionReturnTypeResolver returnTypeResolver) {
        this.returnTypeResolver = returnTypeResolver;
        return this;
    }

    public NamedFunctionTemplateBuilder setInvariantType(AllowableFunctionReturnType invariantType) {
        this.setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant(invariantType));
        return this;
    }

    public NamedFunctionTemplateBuilder setUseParenthesesWhenNoArgs(boolean useParenthesesWhenNoArgs) {
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        return this;
    }

    public SqmFunctionTemplate register() {
        return this.registry.register(this.registrationKey, new NamedSqmFunctionTemplate(this.functionName, this.useParenthesesWhenNoArgs, this.argumentsValidator, this.returnTypeResolver));
    }
}

