/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.produce.function.spi.PatternBasedSqmFunctionTemplate;

public class PatternFunctionTemplateBuilder {
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final String pattern;
    private ArgumentsValidator argumentsValidator;
    private FunctionReturnTypeResolver returnTypeResolver;
    private boolean useParenthesesWhenNoArgs;

    public PatternFunctionTemplateBuilder(SqmFunctionRegistry registry, String registrationKey, String pattern) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.pattern = pattern;
    }

    public PatternFunctionTemplateBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public PatternFunctionTemplateBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public PatternFunctionTemplateBuilder setArgumentsBetween(int min, int max) {
        return this.setArgumentsValidator(StandardArgumentsValidators.between(min, max));
    }

    public PatternFunctionTemplateBuilder setReturnTypeResolver(FunctionReturnTypeResolver returnTypeResolver) {
        this.returnTypeResolver = returnTypeResolver;
        return this;
    }

    public PatternFunctionTemplateBuilder setInvariantType(AllowableFunctionReturnType invariantType) {
        this.setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant(invariantType));
        return this;
    }

    public PatternFunctionTemplateBuilder setUseParenthesesWhenNoArgs(boolean useParenthesesWhenNoArgs) {
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        return this;
    }

    public SqmFunctionTemplate register() {
        return this.registry.register(this.registrationKey, new PatternBasedSqmFunctionTemplate(new PatternRenderer(this.pattern, this.useParenthesesWhenNoArgs), this.argumentsValidator, this.returnTypeResolver));
    }
}

