/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.Map;
import java.util.TreeMap;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.JdbcFunctionEscapeWrapperTemplate;
import org.hibernate.query.sqm.produce.function.NamedFunctionTemplateBuilder;
import org.hibernate.query.sqm.produce.function.PatternFunctionTemplateBuilder;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.VarArgsFunctionTemplateBuilder;
import org.jboss.logging.Logger;

public class SqmFunctionRegistry {
    private static final Logger log = Logger.getLogger(SqmFunctionRegistry.class);
    private final Map<String, SqmFunctionTemplate> functionMap = new TreeMap<String, SqmFunctionTemplate>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> alternateKeyMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public SqmFunctionRegistry() {
        log.tracef("SqmFunctionRegistry created", new Object[0]);
    }

    public SqmFunctionTemplate findFunctionTemplate(String functionName) {
        SqmFunctionTemplate found = null;
        String alternateKeyResolution = this.alternateKeyMap.get(functionName);
        if (alternateKeyResolution != null) {
            found = this.functionMap.get(alternateKeyResolution);
        }
        if (found == null) {
            found = this.functionMap.get(functionName);
        }
        return found;
    }

    public SqmFunctionTemplate register(String registrationKey, SqmFunctionTemplate function) {
        SqmFunctionTemplate priorRegistration = this.functionMap.put(registrationKey, function);
        log.debugf("Registered SqmFunctionTemplate [%s] under %s; prior registration was %s", (Object)function, (Object)registrationKey, (Object)priorRegistration);
        return function;
    }

    public SqmFunctionTemplate registerPattern(String name, String pattern) {
        return this.patternTemplateBuilder(name, pattern).register();
    }

    public SqmFunctionTemplate registerPattern(String name, String pattern, AllowableFunctionReturnType returnType) {
        return this.patternTemplateBuilder(name, pattern).setInvariantType(returnType).register();
    }

    public PatternFunctionTemplateBuilder patternTemplateBuilder(String registrationKey, String pattern) {
        return new PatternFunctionTemplateBuilder(this, registrationKey, pattern);
    }

    public SqmFunctionTemplate registerNamed(String name) {
        return this.namedTemplateBuilder(name).register();
    }

    public SqmFunctionTemplate registerNamed(String name, AllowableFunctionReturnType returnType) {
        return this.namedTemplateBuilder(name).setInvariantType(returnType).register();
    }

    public NamedFunctionTemplateBuilder namedTemplateBuilder(String name) {
        return this.namedTemplateBuilder(name, name);
    }

    public NamedFunctionTemplateBuilder namedTemplateBuilder(String registrationKey, String name) {
        return new NamedFunctionTemplateBuilder(this, registrationKey, name);
    }

    public NamedFunctionTemplateBuilder noArgsBuilder(String name) {
        return this.noArgsBuilder(name, name);
    }

    public NamedFunctionTemplateBuilder noArgsBuilder(String registrationKey, String name) {
        return this.namedTemplateBuilder(registrationKey, name).setExactArgumentCount(0);
    }

    public VarArgsFunctionTemplateBuilder varArgsBuilder(String registrationKey, String begin, String sep, String end) {
        return new VarArgsFunctionTemplateBuilder(this, registrationKey, begin, sep, end);
    }

    public SqmFunctionTemplate registerNoArgs(String name) {
        return this.registerNoArgs(name, name);
    }

    public SqmFunctionTemplate registerNoArgs(String registrationKey, String name) {
        return this.noArgsBuilder(registrationKey, name).register();
    }

    public SqmFunctionTemplate registerNoArgs(String name, AllowableFunctionReturnType returnType) {
        return this.registerNoArgs(name, name, returnType);
    }

    public SqmFunctionTemplate registerNoArgs(String registrationKey, String name, AllowableFunctionReturnType returnType) {
        return this.noArgsBuilder(registrationKey, name).setInvariantType(returnType).register();
    }

    public SqmFunctionTemplate registerVarArgs(String registrationKey, AllowableFunctionReturnType returnType, String begin, String sep, String end) {
        return this.varArgsBuilder(registrationKey, begin, sep, end).setInvariantType(returnType).register();
    }

    public SqmFunctionTemplate wrapInJdbcEscape(String registrationKey, SqmFunctionTemplate wrapped) {
        JdbcFunctionEscapeWrapperTemplate wrapperTemplate = new JdbcFunctionEscapeWrapperTemplate(wrapped);
        this.register(registrationKey, wrapperTemplate);
        return wrapperTemplate;
    }

    public void registerAlternateKey(String alternateKey, String mappedKey) {
        log.debugf("Registering alternate key : %s -> %s", (Object)alternateKey, (Object)mappedKey);
        this.alternateKeyMap.put(alternateKey, mappedKey);
    }

    public void overlay(SqmFunctionRegistry registryToOverly) {
        this.functionMap.forEach(registryToOverly::register);
        this.alternateKeyMap.forEach(registryToOverly::registerAlternateKey);
    }

    public void close() {
        this.functionMap.clear();
        this.alternateKeyMap.clear();
    }
}

