/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.QueryException;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;

public class StandardFunctionReturnTypeResolvers {
    private StandardFunctionReturnTypeResolvers() {
    }

    public static FunctionReturnTypeResolver invariant(final AllowableFunctionReturnType invariantType) {
        if (invariantType == null) {
            throw new IllegalArgumentException("Passed `invariantType` for function return cannot be null");
        }
        return new FunctionReturnTypeResolver(){

            @Override
            public <T> AllowableFunctionReturnType<T> resolveFunctionReturnType(AllowableFunctionReturnType<T> impliedType, List<SqmExpression> arguments) {
                return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(invariantType, impliedType);
            }
        };
    }

    public static FunctionReturnTypeResolver useArgType(final int argPosition) {
        return new FunctionReturnTypeResolver(){

            @Override
            public <T> AllowableFunctionReturnType<T> resolveFunctionReturnType(AllowableFunctionReturnType<T> impliedType, List<SqmExpression> arguments) {
                AllowableFunctionReturnType specifiedArgType = StandardFunctionReturnTypeResolvers.extractArgumentType(arguments, argPosition);
                return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(specifiedArgType, impliedType);
            }
        };
    }

    public static FunctionReturnTypeResolver useFirstNonNull() {
        return new FunctionReturnTypeResolver(){

            @Override
            public <T> AllowableFunctionReturnType<T> resolveFunctionReturnType(AllowableFunctionReturnType<T> impliedType, List<SqmExpression> arguments) {
                Optional<SqmExpression> firstNonNull = arguments.stream().filter(sqmExpression -> sqmExpression.getExpressableType() != null && sqmExpression.getExpressableType() instanceof AllowableFunctionReturnType).findFirst();
                if (firstNonNull.isPresent()) {
                    return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible((AllowableFunctionReturnType)firstNonNull.get().getExpressableType(), impliedType);
                }
                return impliedType;
            }
        };
    }

    private static <T> AllowableFunctionReturnType<T> useImpliedTypeIfPossible(AllowableFunctionReturnType found, AllowableFunctionReturnType implied) {
        return StandardFunctionReturnTypeResolvers.areCompatible(found, implied) ? implied : found;
    }

    private static boolean areCompatible(AllowableFunctionReturnType expected, AllowableFunctionReturnType found) {
        if (expected == null || found == null) {
            return false;
        }
        return expected.getJavaType().isAssignableFrom(found.getJavaType());
    }

    private static AllowableFunctionReturnType extractArgumentType(List<SqmExpression> arguments, int position) {
        SqmExpression specifiedArgument = arguments.get(position - 1);
        ExpressableType specifiedArgType = specifiedArgument.getExpressableType();
        if (!AllowableFunctionReturnType.class.isInstance(specifiedArgType)) {
            throw new QueryException(String.format(Locale.ROOT, "Function argument [%s] at specified position [%d] in call arguments was not typed as an allowable function return type", specifiedArgument, position));
        }
        return (AllowableFunctionReturnType)specifiedArgType;
    }
}

