/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.spi.FunctionAsExpressionTemplate;
import org.jboss.logging.Logger;

public class VarArgsFunctionTemplateBuilder {
    private static final Logger log = Logger.getLogger(VarArgsFunctionTemplateBuilder.class);
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final String begin;
    private final String sep;
    private final String end;
    private ArgumentsValidator argumentsValidator;
    private FunctionReturnTypeResolver returnTypeResolver;

    public VarArgsFunctionTemplateBuilder(SqmFunctionRegistry registry, String registrationKey, String begin, String sep, String end) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.begin = begin;
        this.sep = sep;
        this.end = end;
    }

    public VarArgsFunctionTemplateBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public VarArgsFunctionTemplateBuilder setArgumentCountBetween(int min, int max) {
        return this.setArgumentsValidator(StandardArgumentsValidators.between(min, max));
    }

    public VarArgsFunctionTemplateBuilder setMinArgumentCount(int min) {
        return this.setArgumentsValidator(StandardArgumentsValidators.min(min));
    }

    public VarArgsFunctionTemplateBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public VarArgsFunctionTemplateBuilder setReturnTypeResolver(FunctionReturnTypeResolver returnTypeResolver) {
        this.returnTypeResolver = returnTypeResolver;
        return this;
    }

    public VarArgsFunctionTemplateBuilder setInvariantType(AllowableFunctionReturnType invariantType) {
        this.setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant(invariantType));
        return this;
    }

    public SqmFunctionTemplate register() {
        return this.registry.register(this.registrationKey, new FunctionAsExpressionTemplate(this.begin, this.sep, this.end, this.returnTypeResolver, this.argumentsValidator));
    }
}

