/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.sql.ast.tree.expression.Expression;

public class PatternRenderer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(PatternRenderer.class);
    private final String pattern;
    private final boolean useParenthesisIfNoArgs;
    private final String[] chunks;
    private final int[] paramIndexes;
    private final int paramCount;

    public PatternRenderer(String pattern, boolean useParenthesisIfNoArgs) {
        int i;
        this.pattern = pattern;
        this.useParenthesisIfNoArgs = useParenthesisIfNoArgs;
        HashSet<Integer> paramNumbers = new HashSet<Integer>();
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        StringBuilder chunk = new StringBuilder(10);
        StringBuilder index = new StringBuilder(2);
        int len = pattern.length();
        for (i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                chunkList.add(chunk.toString());
                chunk.delete(0, chunk.length());
                while (++i < pattern.length()) {
                    c = pattern.charAt(i);
                    if (Character.isDigit(c)) {
                        index.append(c);
                        continue;
                    }
                    chunk.append(c);
                    break;
                }
                Integer paramNumber = Integer.valueOf(index.toString());
                paramNumbers.add(paramNumber);
                paramList.add(paramNumber);
                index.delete(0, index.length());
                continue;
            }
            chunk.append(c);
        }
        if (chunk.length() > 0) {
            chunkList.add(chunk.toString());
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.paramIndexes = new int[paramList.size()];
        this.paramCount = paramNumbers.size();
        for (i = 0; i < this.paramIndexes.length; ++i) {
            this.paramIndexes[i] = (Integer)paramList.get(i);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getAnticipatedNumberOfArguments() {
        return this.paramIndexes.length;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public String render(List<Expression> args, SessionFactoryImplementor factory) {
        int numberOfArguments = args.size();
        if (this.getAnticipatedNumberOfArguments() > 0 && numberOfArguments != this.getAnticipatedNumberOfArguments()) {
            LOG.missingArguments(this.getAnticipatedNumberOfArguments(), numberOfArguments);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.chunks.length; ++i) {
            if (i < this.paramIndexes.length) {
                Expression arg;
                int index = this.paramIndexes[i] - 1;
                Expression expression = arg = index < numberOfArguments ? args.get(index) : null;
                if (arg == null) continue;
                buf.append(this.chunks[i]).append(arg);
                continue;
            }
            buf.append(this.chunks[i]);
        }
        return buf.toString();
    }
}

