/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SelfRenderingExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.spi.SqlExpressable;
import org.hibernate.sql.ast.produce.sqm.spi.SqmToSqlAstConverter;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.Selectable;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingFunctionSqlAstExpression
implements SelfRenderingExpression,
Selectable,
SqlExpressable,
DomainResultProducer {
    private final SelfRenderingSqmFunction sqmExpression;
    private final List<Expression> sqlAstArguments;
    private final TypeConfiguration typeConfiguration;

    public SelfRenderingFunctionSqlAstExpression(SelfRenderingSqmFunction sqmExpression, SqmToSqlAstConverter walker) {
        this.sqmExpression = sqmExpression;
        this.sqlAstArguments = SelfRenderingFunctionSqlAstExpression.resolveSqlAstArguments(sqmExpression.getSqmArguments(), walker);
        this.typeConfiguration = walker.getCreationContext().getDomainModel().getTypeConfiguration();
    }

    private static List<Expression> resolveSqlAstArguments(List<SqmExpression> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> sqlAstArguments = new ArrayList<Expression>();
        for (SqmExpression sqmArgument : sqmArguments) {
            sqlAstArguments.add((Expression)sqmArgument.accept(walker));
        }
        return sqlAstArguments;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return ((BasicValuedExpressableType)((Object)this.getType())).getSqlExpressableType();
    }

    @Override
    public SqlExpressableType getType() {
        return this.sqmExpression.getExpressableType().getSqlExpressableType(this.typeConfiguration);
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, null, this.getExpressableType());
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.getExpressableType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.getExpressableType());
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        this.sqmExpression.getRenderingSupport().render(sqlAppender, this.sqlAstArguments, walker, sessionFactory);
    }
}

