/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.Arrays;
import java.util.List;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.spi.TrimSpecificationExpressionWrapper;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmGenericFunction;
import org.hibernate.sql.TrimSpecification;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class AnsiTrimEmulationFunctionTemplate
implements SqmFunctionTemplate {
    public static final String LTRIM = "ltrim";
    public static final String RTRIM = "rtrim";
    public static final String REPLACE = "replace";
    public static final String TRIM_CHAR_PLACEHOLDER = "${space}$";
    private final String ltrimFunctionName;
    private final String rtrimFunctionName;
    private final String replaceFunctionName;

    public AnsiTrimEmulationFunctionTemplate() {
        this(LTRIM, RTRIM, REPLACE);
    }

    public AnsiTrimEmulationFunctionTemplate(String ltrimFunctionName, String rtrimFunctionName, String replaceFunctionName) {
        this.ltrimFunctionName = ltrimFunctionName;
        this.rtrimFunctionName = rtrimFunctionName;
        this.replaceFunctionName = replaceFunctionName;
    }

    @Override
    public SqmFunction makeSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        TrimSpecification specification = ((TrimSpecificationExpressionWrapper)arguments.get(0)).getSpecification();
        SqmLiteral trimCharacterExpr = (SqmLiteral)arguments.get(1);
        SqmExpression sourceExpr = arguments.get(1);
        switch (specification) {
            case LEADING: {
                return this.trimLeading(trimCharacterExpr, sourceExpr);
            }
            case TRAILING: {
                return this.trimTrailing(trimCharacterExpr, sourceExpr);
            }
        }
        return this.trimBoth(trimCharacterExpr, sourceExpr);
    }

    private SqmFunction trimLeading(SqmLiteral<Character> trimChar, SqmExpression source) {
        if (trimChar.getLiteralValue().charValue() == ' ') {
            return this.trimLeadingSpaces(source);
        }
        return this.trimLeadingNonSpaces(trimChar, source);
    }

    private SqmFunction trimLeadingSpaces(SqmExpression source) {
        return this.ltrim(source);
    }

    private SqmFunction trimLeadingNonSpaces(SqmLiteral<Character> trimChar, SqmExpression source) {
        SqmLiteral<Character> space = this.charExpr(' ');
        SqmLiteral<String> placeholder = this.placeholder();
        return this.replace(this.replace(this.ltrim(this.replace(this.replace(source, space, placeholder), space, placeholder)), space, trimChar), placeholder, space);
    }

    private SqmFunction trimTrailing(SqmLiteral<Character> trimChar, SqmExpression source) {
        if (trimChar.getLiteralValue().charValue() == ' ') {
            return this.trimTrailingSpaces(source);
        }
        return this.trimTrailingNonSpaces(trimChar, source);
    }

    private SqmFunction trimTrailingSpaces(SqmExpression sourceExpr) {
        return this.rtrim(sourceExpr);
    }

    private SqmFunction trimTrailingNonSpaces(SqmLiteral<Character> trimChar, SqmExpression source) {
        SqmLiteral<Character> space = this.charExpr(' ');
        SqmLiteral<String> placeholder = this.placeholder();
        return this.replace(this.replace(this.rtrim(this.replace(this.replace(source, space, placeholder), space, placeholder)), space, trimChar), placeholder, space);
    }

    private SqmFunction trimBoth(SqmLiteral<Character> trimCharacterExpr, SqmExpression sourceExpr) {
        if (trimCharacterExpr.getLiteralValue().charValue() == ' ') {
            return this.trimBothSpaces(sourceExpr);
        }
        return this.trimBothNonSpaces(trimCharacterExpr, sourceExpr);
    }

    private SqmFunction trimBothSpaces(SqmExpression sourceExpr) {
        return this.ltrim(this.rtrim(sourceExpr));
    }

    private SqmFunction trimBothNonSpaces(SqmLiteral<Character> trimChar, SqmExpression source) {
        SqmLiteral<Character> space = this.charExpr(' ');
        SqmLiteral<String> placeholder = this.placeholder();
        return this.replace(this.replace(this.ltrim(this.rtrim(this.replace(this.replace(source, space, placeholder), space, placeholder))), space, trimChar), placeholder, space);
    }

    protected SqmFunction replace(SqmExpression source, SqmExpression searchPattern, SqmExpression replacement) {
        return AnsiTrimEmulationFunctionTemplate.function(this.replaceFunctionName, source, searchPattern, replacement);
    }

    protected SqmFunction rtrim(SqmExpression source) {
        return AnsiTrimEmulationFunctionTemplate.function(this.rtrimFunctionName, source);
    }

    protected SqmFunction ltrim(SqmExpression source) {
        return AnsiTrimEmulationFunctionTemplate.function(this.ltrimFunctionName, source);
    }

    private static SqmGenericFunction function(String name, SqmExpression ... arguments) {
        return new SqmGenericFunction(name, StandardSpiBasicTypes.STRING, Arrays.asList(arguments));
    }

    protected final SqmLiteral<String> placeholder() {
        return new SqmLiteral<String>(TRIM_CHAR_PLACEHOLDER, StandardSpiBasicTypes.STRING);
    }

    protected SqmLiteral<Character> charExpr(char trimChar) {
        return new SqmLiteral<Character>(Character.valueOf(trimChar), StandardSpiBasicTypes.CHARACTER);
    }
}

