/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.jboss.logging.Logger;

public class FunctionAsExpressionTemplate
extends AbstractSelfRenderingFunctionTemplate
implements SelfRenderingFunctionSupport {
    private static final Logger log = Logger.getLogger(FunctionAsExpressionTemplate.class);
    private final String expressionStart;
    private final String argumentSeparator;
    private final String expressionEnd;

    public FunctionAsExpressionTemplate(String expressionStart, String argumentSeparator, String expressionEnd) {
        this(expressionStart, argumentSeparator, expressionEnd, null);
    }

    public FunctionAsExpressionTemplate(String expressionStart, String argumentSeparator, String expressionEnd, FunctionReturnTypeResolver returnTypeResolver) {
        this(expressionStart, argumentSeparator, expressionEnd, returnTypeResolver, null);
    }

    public FunctionAsExpressionTemplate(String expressionStart, String argumentSeparator, String expressionEnd, FunctionReturnTypeResolver returnTypeResolver, ArgumentsValidator argumentsValidator) {
        super(returnTypeResolver, argumentsValidator);
        this.expressionStart = expressionStart;
        this.argumentSeparator = argumentSeparator;
        this.expressionEnd = expressionEnd;
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmExpression> arguments, AllowableFunctionReturnType resolvedReturnType) {
        return this;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAppender.appendSql(this.expressionStart);
        if (sqlAstArguments.isEmpty()) {
            log.debugf("No arguments found for FunctionAsExpressionTemplate, this is most likely a query syntax error", new Object[0]);
        } else {
            sqlAstArguments.get(0).accept(walker);
            this.renderArgument(sqlAppender, sqlAstArguments.get(0), walker, sessionFactory);
            for (int i = 1; i < sqlAstArguments.size(); ++i) {
                sqlAppender.appendSql(this.argumentSeparator);
                this.renderArgument(sqlAppender, sqlAstArguments.get(i), walker, sessionFactory);
            }
        }
        sqlAppender.appendSql(this.expressionEnd);
    }

    protected void renderArgument(SqlAppender sqlAppender, Expression sqlAstArgument, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAstArgument.accept(walker);
    }
}

