/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import java.util.Locale;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;

public class NamedSqmFunctionTemplate
extends AbstractSelfRenderingFunctionTemplate {
    private final String functionName;
    private final boolean useParenthesesWhenNoArgs;

    public NamedSqmFunctionTemplate(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        super(returnTypeResolver, argumentsValidator);
        this.functionName = functionName;
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
    }

    public String getName() {
        return this.functionName;
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
        return new RenderingSupport();
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmFunctionTemplate(%s)", this.functionName);
    }

    public static class Builder {
    }

    private class RenderingSupport
    implements SelfRenderingFunctionSupport {
        RenderingSupport() {
        }

        @Override
        public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
            boolean useParens = NamedSqmFunctionTemplate.this.useParenthesesWhenNoArgs || !sqlAstArguments.isEmpty();
            sqlAppender.appendSql(NamedSqmFunctionTemplate.this.functionName);
            if (useParens) {
                sqlAppender.appendSql("(");
            }
            boolean firstPass = true;
            for (Expression sqlAstArgument : sqlAstArguments) {
                if (!firstPass) {
                    sqlAppender.appendSql(", ");
                }
                sqlAstArgument.accept(walker);
                firstPass = false;
            }
            if (useParens) {
                sqlAppender.appendSql(")");
            }
        }
    }
}

