/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.spi.AbstractSqmFunctionTemplate;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.SqmAvgFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCastFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountStarFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMaxFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMinFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSumFunction;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class StandardAnsiSqlSqmAggregationFunctionTemplates {
    public static void primeFunctionMap(Map<String, SqmFunctionTemplate> functionMap) {
        functionMap.put("avg", AvgFunctionTemplate.INSTANCE);
        functionMap.put("count", CountFunctionTemplate.INSTANCE);
        functionMap.put("max", MaxFunctionTemplate.INSTANCE);
        functionMap.put("min", MinFunctionTemplate.INSTANCE);
        functionMap.put("sum", SumFunctionTemplate.INSTANCE);
    }

    private StandardAnsiSqlSqmAggregationFunctionTemplates() {
    }

    static SqmExpression cast(SqmExpression argument, String sqlCastTypeForFloatingPointArgTypes) {
        return new SqmCastFunction(argument, StandardSpiBasicTypes.DOUBLE, sqlCastTypeForFloatingPointArgTypes);
    }

    public static class SumFunctionTemplate
    extends AbstractSqmFunctionTemplate {
        public static final SumFunctionTemplate INSTANCE = new SumFunctionTemplate();

        protected SumFunctionTemplate() {
            super(StandardArgumentsValidators.exactly(1));
        }

        @Override
        protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
            SqmExpression argument = arguments.get(0);
            return new SqmSumFunction(argument, this.deduceReturnType(argument.getExpressableType()));
        }

        private AllowableFunctionReturnType deduceReturnType(ExpressableType argumentType) {
            Class argumentJavaType = argumentType.getJavaType();
            boolean isArgumentTypeAllowable = argumentType instanceof AllowableFunctionReturnType;
            if (BigInteger.class.equals((Object)argumentJavaType)) {
                return isArgumentTypeAllowable ? (AllowableFunctionReturnType)argumentType : StandardSpiBasicTypes.BIG_INTEGER;
            }
            if (BigDecimal.class.equals((Object)argumentJavaType)) {
                return isArgumentTypeAllowable ? (AllowableFunctionReturnType)argumentType : StandardSpiBasicTypes.BIG_DECIMAL;
            }
            if (Long.class.equals((Object)argumentJavaType)) {
                return isArgumentTypeAllowable ? (AllowableFunctionReturnType)argumentType : StandardSpiBasicTypes.LONG;
            }
            if (Double.class.equals((Object)argumentJavaType)) {
                return isArgumentTypeAllowable ? (AllowableFunctionReturnType)argumentType : StandardSpiBasicTypes.DOUBLE;
            }
            if (Short.class.equals((Object)argumentJavaType)) {
                return StandardSpiBasicTypes.LONG;
            }
            if (Integer.class.equals((Object)argumentJavaType)) {
                return StandardSpiBasicTypes.LONG;
            }
            if (Float.class.equals((Object)argumentJavaType)) {
                return StandardSpiBasicTypes.DOUBLE;
            }
            return StandardSpiBasicTypes.DOUBLE;
        }
    }

    public static class MinFunctionTemplate
    extends AbstractSqmFunctionTemplate {
        public static final MinFunctionTemplate INSTANCE = new MinFunctionTemplate();

        protected MinFunctionTemplate() {
            super(StandardArgumentsValidators.exactly(1));
        }

        @Override
        protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
            return new SqmMinFunction(arguments.get(0));
        }
    }

    public static class MaxFunctionTemplate
    extends AbstractSqmFunctionTemplate {
        public static final MaxFunctionTemplate INSTANCE = new MaxFunctionTemplate();

        protected MaxFunctionTemplate() {
            super(StandardArgumentsValidators.exactly(1));
        }

        @Override
        protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
            return new SqmMaxFunction(arguments.get(0));
        }
    }

    public static class AvgFunctionTemplate
    extends AbstractSqmFunctionTemplate {
        public static final AvgFunctionTemplate INSTANCE = new AvgFunctionTemplate(null);
        private final String sqlCastTypeForFloatingPointArgTypes;

        public AvgFunctionTemplate(String sqlCastTypeForFloatingPointArgTypes) {
            super(StandardArgumentsValidators.exactly(1));
            this.sqlCastTypeForFloatingPointArgTypes = sqlCastTypeForFloatingPointArgTypes;
        }

        @Override
        protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
            SqmExpression argument = arguments.get(0);
            Class argumentJavaType = argument.getExpressableType().getJavaType();
            boolean isFloatingPointNumber = Float.class.isInstance(argumentJavaType) || Double.class.isInstance(argumentJavaType);
            boolean needsCast = this.sqlCastTypeForFloatingPointArgTypes != null && !isFloatingPointNumber;
            SqmExpression argumentToPass = needsCast ? StandardAnsiSqlSqmAggregationFunctionTemplates.cast(argument, this.sqlCastTypeForFloatingPointArgTypes) : argument;
            return new SqmAvgFunction(argumentToPass);
        }
    }

    public static class CountFunctionTemplate
    extends AbstractSqmFunctionTemplate {
        public static final CountFunctionTemplate INSTANCE = new CountFunctionTemplate();

        private CountFunctionTemplate() {
            super(StandardArgumentsValidators.exactly(1));
        }

        @Override
        protected SqmExpression generateSqmFunctionExpression(List<SqmExpression> arguments, AllowableFunctionReturnType impliedResultType) {
            assert (!arguments.isEmpty());
            if (arguments.get(0) == SqmCountStarFunction.STAR) {
                return new SqmCountStarFunction(impliedResultType);
            }
            return new SqmCountFunction(arguments.get(0), impliedResultType);
        }
    }
}

