/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.internal;

import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaUpdate;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.criteria.spi.RootQuery;
import org.hibernate.query.criteria.sqm.CriteriaQueryToSqmTransformer;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.HqlParseTreePrinter;
import org.hibernate.query.hql.internal.HqlParser;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.produce.SemanticQueryProducer;
import org.hibernate.query.sqm.produce.internal.SqmCreationOptionsStandard;
import org.hibernate.query.sqm.produce.internal.SqmTreePrinter;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class SemanticQueryProducerImpl
implements SemanticQueryProducer {
    private final SessionFactoryImplementor sessionFactory;

    public SemanticQueryProducerImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public SqmStatement interpret(String query) {
        HqlParser parser = HqlParseTreeBuilder.INSTANCE.parseHql(query);
        HqlParseTreePrinter.logStatementParseTree(parser);
        try {
            SqmStatement sqmStatement = SemanticQueryBuilder.buildSemanticModel(parser.statement(), new SqmCreationOptionsStandard(this.sessionFactory), this.sessionFactory);
            SqmTreePrinter.logTree(sqmStatement);
            return sqmStatement;
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InterpretationException(query, e);
        }
    }

    @Override
    public <R> SqmSelectStatement interpret(RootQuery<R> query) {
        return CriteriaQueryToSqmTransformer.transform(query, this.sessionFactory);
    }

    @Override
    public <E> SqmDeleteStatement<E> interpret(CriteriaDelete<E> criteria) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmUpdateStatement interpret(CriteriaUpdate criteria) {
        throw new NotYetImplementedFor6Exception();
    }
}

