/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.internal;

import java.lang.reflect.Field;
import java.util.Locale;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.criteria.sqm.JpaParameterSqmWrapper;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmConcat;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmSubQuery;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.function.SqmAbsFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmAvgFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmBitLengthFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCastFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCoalesceFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmConcatFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountStarFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentDateFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentTimeFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentTimestampFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmExtractFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmGenericFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLengthFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLocateFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLowerFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMaxFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMinFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmModFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmNullifFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSqrtFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmStrFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSubstringFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSumFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmTrimFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmUpperFunction;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.AndSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.BetweenSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.BooleanExpressionSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.EmptinessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.GroupedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InListSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InSubQuerySqmPredicate;
import org.hibernate.query.sqm.tree.predicate.LikeSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.MemberOfSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NegatedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NullnessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.OrSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmGroupByClause;
import org.hibernate.query.sqm.tree.select.SqmHavingClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.produce.ordering.internal.SqmColumnReference;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;
import org.jboss.logging.Logger;

public class SqmTreePrinter
implements SemanticQueryWalker {
    private static final Logger log = Logger.getLogger(SqmTreePrinter.class);
    private static final Logger LOGGER = QueryLogger.subLogger("sqm.sqmTree");
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void logTree(SqmStatement sqmStatement) {
        SqmTreePrinter printer = new SqmTreePrinter();
        if (sqmStatement instanceof SqmSelectStatement) {
            printer.visitSelectStatement((SqmSelectStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmDeleteStatement) {
            printer.visitDeleteStatement((SqmDeleteStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmUpdateStatement) {
            printer.visitUpdateStatement((SqmUpdateStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmInsertSelectStatement) {
            printer.visitInsertSelectStatement((SqmInsertSelectStatement)sqmStatement);
        }
        LOGGER.debugf("Semantic Query (SQM) Tree :\n%s", (Object)printer.buffer.toString());
    }

    private void processStanza(String name, Runnable continuation) {
        this.processStanza(name, false, continuation);
    }

    private void processStanza(String name, String description, Runnable continuation) {
        this.processStanza(name, description, false, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, boolean indentContinuation, Runnable continuation) {
        this.logWithIndentation("-> [%s]", (Object)name);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- [%s]", (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, String description, boolean indentContinuation, Runnable continuation) {
        String stanzaLabel = description == null ? "[" + name + ']' : "[" + name + "] - " + description;
        this.logWithIndentation("-> " + stanzaLabel);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- " + stanzaLabel);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append('\n');
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object ... args) {
        this.logWithIndentation(String.format(pattern, args));
    }

    private void logIndented(String line) {
        ++this.depth;
        this.logWithIndentation(line);
        --this.depth;
    }

    private void logIndented(String pattern, Object arg) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg));
        --this.depth;
    }

    private void logIndented(String pattern, Object arg1, Object arg2) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg1, arg2));
        --this.depth;
    }

    private void logIndented(String pattern, Object ... args) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, args));
        --this.depth;
    }

    public Object visitDeleteStatement(SqmDeleteStatement statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("delete", () -> {
                this.logWithIndentation("[target = %s]", (Object)statement.getTarget().getNavigablePath().getFullPath());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    public Object visitInsertSelectStatement(SqmInsertSelectStatement statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("insert", () -> {
                this.logWithIndentation("[target = %s]", (Object)statement.getTarget().getNavigablePath().getFullPath());
                this.processStanza("into", () -> statement.getInsertionTargetPaths().forEach(sqmPath -> sqmPath.accept(this)));
                this.visitQuerySpec(statement.getSelectQuerySpec());
            });
        }
        return null;
    }

    public Object visitSelectStatement(SqmSelectStatement statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("select", () -> this.visitQuerySpec(statement.getQuerySpec()));
        }
        return null;
    }

    public Object visitUpdateStatement(SqmUpdateStatement statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("update", () -> {
                this.logWithIndentation("[target = %s]", (Object)statement.getTarget().getNavigablePath().getFullPath());
                this.visitSetClause(statement.getSetClause());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    public Object visitSetClause(SqmSetClause setClause) {
        this.processStanza("set", () -> setClause.getAssignments().forEach(this::visitAssignment));
        return null;
    }

    public Object visitAssignment(SqmAssignment assignment) {
        this.processStanza("assignment", () -> {
            this.logWithIndentation("=");
            ++this.depth;
            this.logWithIndentation("[%s]", (Object)assignment.getTargetPath().getNavigablePath());
            assignment.getValue().accept(this);
            --this.depth;
        });
        return null;
    }

    public Object visitQuerySpec(SqmQuerySpec querySpec) {
        this.processStanza("query-spec", () -> {
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitGroupByClause(querySpec.getGroupByClause());
            this.visitHavingClause(querySpec.getHavingClause());
            this.visitWhereClause(querySpec.getWhereClause());
            this.visitOrderByClause(querySpec.getOrderByClause());
            this.visitLimitExpression(querySpec.getLimitExpression());
            this.visitOffsetExpression(querySpec.getOffsetExpression());
        });
        return null;
    }

    public Object visitGroupByClause(SqmGroupByClause clause) {
        if (clause != null) {
            this.processStanza("group-by", () -> clause.visitGroupings(this::visitGrouping));
        }
        return null;
    }

    public Object visitGrouping(SqmGroupByClause.SqmGrouping grouping) {
        this.processStanza("grouping", () -> grouping.getExpression().accept(this));
        return null;
    }

    public Object visitHavingClause(SqmHavingClause clause) {
        if (clause != null) {
            this.processStanza("having", () -> clause.getPredicate().accept(this));
        }
        return null;
    }

    public Object visitFromClause(SqmFromClause fromClause) {
        this.processStanza("from", () -> fromClause.visitRoots(this::visitRootPath));
        return null;
    }

    public Object visitRootPath(SqmRoot sqmRoot) {
        this.processStanza("root", '`' + sqmRoot.getNavigablePath().getFullPath() + '`', () -> this.processJoins(sqmRoot));
        return null;
    }

    private void processJoins(SqmFrom sqmFrom) {
        if (!sqmFrom.hasJoins()) {
            return;
        }
        this.processStanza("joins", () -> sqmFrom.visitJoins(sqmJoin -> sqmJoin.accept(this)));
    }

    public Object visitCrossJoinedFromElement(SqmCrossJoin joinedFromElement) {
        this.processStanza("cross", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> this.processJoins(joinedFromElement));
        return null;
    }

    public Object visitQualifiedEntityJoinFromElement(SqmEntityJoin joinedFromElement) {
        this.processStanza("entity", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> {
            if (joinedFromElement.getJoinPredicate() != null) {
                this.processStanza("on", () -> joinedFromElement.getJoinPredicate().accept(this));
            }
            this.processJoins(joinedFromElement);
        });
        return null;
    }

    public Object visitQualifiedAttributeJoinFromElement(SqmNavigableJoin joinedFromElement) {
        this.processStanza("attribute", '`' + joinedFromElement.getNavigablePath().getFullPath() + '`', () -> {
            this.logIndented("[fetched = " + joinedFromElement.isFetched() + ']');
            if (joinedFromElement.getJoinPredicate() != null) {
                this.processStanza("on", () -> joinedFromElement.getJoinPredicate().accept(this));
            }
            this.processJoins(joinedFromElement);
        });
        return null;
    }

    public Object visitBasicValuedPath(SqmBasicValuedSimplePath path) {
        this.logWithIndentation("-> [basic-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    public Object visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath path) {
        this.logWithIndentation("-> [embedded-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    public Object visitEntityValuedPath(SqmEntityValuedSimplePath path) {
        this.logWithIndentation("-> [entity-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    public Object visitPluralValuedPath(SqmPluralValuedSimplePath path) {
        this.logWithIndentation("-> [plural-path] - `%s`", (Object)path.getNavigablePath().getFullPath());
        return null;
    }

    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath path) {
        return null;
    }

    public Object visitSelectClause(SqmSelectClause selectClause) {
        this.processStanza(selectClause.isDistinct() ? "select(distinct)" : "select", () -> selectClause.getSelections().forEach(this::visitSelection));
        return null;
    }

    public Object visitSelection(SqmSelection selection) {
        this.processStanza(selection.getAlias() == null ? "selection" : "selection(" + selection.getAlias() + ")", () -> selection.getSelectableNode().accept(this));
        return null;
    }

    public Object visitTreatedPath(SqmTreatedPath sqmTreatedPath) {
        return null;
    }

    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        this.logWithIndentation("?%s", (Object)expression.getPosition());
        return null;
    }

    public Object visitNamedParameterExpression(SqmNamedParameter expression) {
        this.logWithIndentation(":%s", (Object)expression.getName());
        return null;
    }

    public Object visitJpaParameterWrapper(JpaParameterSqmWrapper expression) {
        return null;
    }

    public Object visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
        return null;
    }

    public Object visitParameterizedEntityTypeExpression(SqmParameterizedEntityType expression) {
        return null;
    }

    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        return null;
    }

    public Object visitGenericFunction(SqmGenericFunction expression) {
        return null;
    }

    public Object visitSqlAstFunctionProducer(SqlAstFunctionProducer sqlAstFunctionProducer) {
        return null;
    }

    public Object visitAbsFunction(SqmAbsFunction function) {
        return null;
    }

    public Object visitAvgFunction(SqmAvgFunction expression) {
        return null;
    }

    public Object visitBitLengthFunction(SqmBitLengthFunction sqmBitLengthFunction) {
        return null;
    }

    public Object visitCastFunction(SqmCastFunction expression) {
        return null;
    }

    public Object visitCoalesceFunction(SqmCoalesceFunction expression) {
        return null;
    }

    public Object visitCountFunction(SqmCountFunction expression) {
        return null;
    }

    public Object visitCountStarFunction(SqmCountStarFunction expression) {
        return null;
    }

    public Object visitCurrentDateFunction(SqmCurrentDateFunction sqmCurrentDate) {
        return null;
    }

    public Object visitCurrentTimeFunction(SqmCurrentTimeFunction sqmCurrentTimeFunction) {
        return null;
    }

    public Object visitCurrentTimestampFunction(SqmCurrentTimestampFunction sqmCurrentTimestampFunction) {
        return null;
    }

    public Object visitExtractFunction(SqmExtractFunction function) {
        return null;
    }

    public Object visitLengthFunction(SqmLengthFunction sqmLengthFunction) {
        return null;
    }

    public Object visitLocateFunction(SqmLocateFunction function) {
        return null;
    }

    public Object visitLowerFunction(SqmLowerFunction expression) {
        return null;
    }

    public Object visitMaxFunction(SqmMaxFunction expression) {
        return null;
    }

    public Object visitMinFunction(SqmMinFunction expression) {
        return null;
    }

    public Object visitModFunction(SqmModFunction sqmModFunction) {
        return null;
    }

    public Object visitNullifFunction(SqmNullifFunction expression) {
        return null;
    }

    public Object visitSqrtFunction(SqmSqrtFunction sqmSqrtFunction) {
        return null;
    }

    public Object visitStrFunction(SqmStrFunction sqmStrFunction) {
        return null;
    }

    public Object visitSubstringFunction(SqmSubstringFunction expression) {
        return null;
    }

    public Object visitSumFunction(SqmSumFunction expression) {
        return null;
    }

    public Object visitTrimFunction(SqmTrimFunction expression) {
        return null;
    }

    public Object visitUpperFunction(SqmUpperFunction expression) {
        return null;
    }

    public Object visitWhereClause(SqmWhereClause whereClause) {
        if (whereClause != null && whereClause.getPredicate() != null) {
            this.processStanza("where", () -> whereClause.getPredicate().accept(this));
        }
        return null;
    }

    public Object visitGroupedPredicate(GroupedSqmPredicate predicate) {
        this.processStanza("grouped", () -> {
            ++this.depth;
            predicate.getSubPredicate().accept(this);
            --this.depth;
        });
        return null;
    }

    public Object visitAndPredicate(AndSqmPredicate predicate) {
        this.processStanza("and", () -> {
            predicate.getLeftHandPredicate().accept(this);
            predicate.getRightHandPredicate().accept(this);
        });
        return null;
    }

    public Object visitOrPredicate(OrSqmPredicate predicate) {
        this.processStanza("or", () -> {
            predicate.getLeftHandPredicate().accept(this);
            predicate.getRightHandPredicate().accept(this);
        });
        return null;
    }

    public Object visitComparisonPredicate(SqmComparisonPredicate predicate) {
        this.processStanza(predicate.isNegated() ? predicate.getOperator().negated().name() : predicate.getOperator().name(), () -> {
            ++this.depth;
            try {
                predicate.getLeftHandExpression().accept(this);
                predicate.getRightHandExpression().accept(this);
            }
            finally {
                --this.depth;
            }
        });
        return null;
    }

    public Object visitIsEmptyPredicate(EmptinessSqmPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-empty" : "is-empty", () -> {
            ++this.depth;
            predicate.getPluralPath().accept(this);
            --this.depth;
        });
        return null;
    }

    public Object visitIsNullPredicate(NullnessSqmPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-null" : "is-null", true, () -> predicate.getExpression().accept(this));
        return null;
    }

    public Object visitBetweenPredicate(BetweenSqmPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-between" : "is-between", () -> {
            predicate.getExpression().accept(this);
            predicate.getLowerBound().accept(this);
            predicate.getUpperBound().accept(this);
        });
        return null;
    }

    public Object visitLikePredicate(LikeSqmPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-like" : "is-like", () -> {
            predicate.getPattern().accept(this);
            predicate.getMatchExpression().accept(this);
            predicate.getEscapeCharacter().accept(this);
        });
        return null;
    }

    public Object visitMemberOfPredicate(MemberOfSqmPredicate predicate) {
        return null;
    }

    public Object visitNegatedPredicate(NegatedSqmPredicate predicate) {
        return null;
    }

    public Object visitInListPredicate(InListSqmPredicate predicate) {
        return null;
    }

    public Object visitInSubQueryPredicate(InSubQuerySqmPredicate predicate) {
        return null;
    }

    public Object visitBooleanExpressionPredicate(BooleanExpressionSqmPredicate predicate) {
        return null;
    }

    public Object visitOrderByClause(SqmOrderByClause orderByClause) {
        return null;
    }

    public Object visitSortSpecification(SqmSortSpecification sortSpecification) {
        return null;
    }

    public Object visitOffsetExpression(SqmExpression expression) {
        return null;
    }

    public Object visitLimitExpression(SqmExpression expression) {
        return null;
    }

    public Object visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        return null;
    }

    public Object visitMapEntryFunction(SqmMapEntryReference function) {
        return null;
    }

    public Object visitMaxElementPath(SqmMaxElementPath binding) {
        return null;
    }

    public Object visitMinElementPath(SqmMinElementPath path) {
        return null;
    }

    public Object visitMaxIndexPath(SqmMaxIndexPath path) {
        return null;
    }

    public Object visitMinIndexPath(SqmMinIndexPath path) {
        return null;
    }

    public Object visitLiteral(SqmLiteral literal) {
        return null;
    }

    public Object visitConcatExpression(SqmConcat expression) {
        return null;
    }

    public Object visitConcatFunction(SqmConcatFunction expression) {
        return null;
    }

    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        return null;
    }

    public Object visitSubQueryExpression(SqmSubQuery expression) {
        return null;
    }

    public Object visitSimpleCaseExpression(SqmCaseSimple expression) {
        return null;
    }

    public Object visitSearchedCaseExpression(SqmCaseSearched expression) {
        return null;
    }

    public Object visitExplicitColumnReference(SqmColumnReference sqmColumnReference) {
        return null;
    }

    public Object visitDynamicInstantiation(SqmDynamicInstantiation sqmDynamicInstantiation) {
        this.processStanza("dynamic-instantiation (" + sqmDynamicInstantiation.getInstantiationTarget().getJavaType() + ')', () -> this.processStanza("arguments", () -> sqmDynamicInstantiation.getArguments().forEach(argument -> this.processStanza("argument (" + argument.getAlias() + ')', () -> {
            ++this.depth;
            argument.getSelectableNode().accept(this);
            --this.depth;
        }))));
        return null;
    }

    public Object visitFullyQualifiedField(Field field) {
        return null;
    }

    public Object visitFullyQualifiedEnum(Enum value) {
        return null;
    }

    public Object visitFullyQualifiedClass(Class namedClass) {
        return null;
    }
}

