/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.function.Supplier;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.SqmCreationHelper;
import org.hibernate.query.sqm.produce.SqmPathRegistry;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;

public class SqmEmbeddedValuedSimplePath
extends AbstractSqmSimplePath {
    private boolean dereferenced;

    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, EmbeddedValuedNavigable referencedNavigable, SqmPath lhs) {
        super(navigablePath, referencedNavigable, lhs);
    }

    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, EmbeddedValuedNavigable referencedNavigable, SqmPath lhs, String explicitAlias) {
        super(navigablePath, referencedNavigable, lhs, explicitAlias);
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        Navigable subNavigable = this.getReferencedNavigable().findNavigable(name);
        if (subNavigable == null) {
            throw UnknownPathException.unknownSubPath(this, name);
        }
        this.prepareForSubNavigableReference(subNavigable, isTerminal, creationState);
        return subNavigable.createSqmExpression(this, creationState);
    }

    @Override
    public EmbeddedValuedNavigable getReferencedNavigable() {
        return (EmbeddedValuedNavigable)super.getReferencedNavigable();
    }

    @Override
    public EmbeddedValuedNavigable getExpressableType() {
        return (EmbeddedValuedNavigable)super.getExpressableType();
    }

    public Supplier<? extends EmbeddedValuedNavigable> getInferableType() {
        return this::getReferencedNavigable;
    }

    @Override
    public EmbeddableJavaDescriptor getJavaTypeDescriptor() {
        return (EmbeddableJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitEmbeddableValuedPath(this);
    }

    @Override
    public void prepareForSubNavigableReference(Navigable subNavigable, boolean isSubReferenceTerminal, SqmCreationState creationState) {
        if (this.dereferenced) {
            return;
        }
        SqmCreationHelper.resolveAsLhs(this.getLhs(), this, subNavigable, isSubReferenceTerminal, creationState);
        SqmPathRegistry pathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
        pathRegistry.resolvePath(this.getNavigablePath(), navigablePath -> {
            NavigablePath lhsNavigablePath = this.getLhs().getNavigablePath();
            SqmFrom lhsFrom = pathRegistry.findFromByPath(lhsNavigablePath);
            if (lhsFrom == null) {
                throw new ParsingException("Unable to resolve SqmFrom : `" + lhsNavigablePath.getFullPath() + '`');
            }
            return lhsFrom;
        });
        this.dereferenced = true;
    }
}

