/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.function.Supplier;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.SqmCreationHelper;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;

public class SqmEntityValuedSimplePath
extends AbstractSqmSimplePath {
    private boolean dereferenced;

    public SqmEntityValuedSimplePath(NavigablePath navigablePath, EntityValuedNavigable<?> referencedNavigable, SqmPath lhs) {
        super(navigablePath, referencedNavigable, lhs);
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        EntityValuedNavigable referencedNavigable = this.getReferencedNavigable();
        Navigable navigable = referencedNavigable.findNavigable(name);
        this.prepareForSubNavigableReference(referencedNavigable, isTerminal, creationState);
        assert (this.getLhs() == null || creationState.getProcessingStateStack().getCurrent().getPathRegistry().findPath(this.getLhs().getNavigablePath()) != null);
        return navigable.createSqmExpression(this, creationState);
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitEntityValuedPath(this);
    }

    @Override
    public EntityValuedNavigable getReferencedNavigable() {
        return (EntityValuedNavigable)super.getReferencedNavigable();
    }

    @Override
    public void prepareForSubNavigableReference(Navigable subNavigable, boolean isSubReferenceTerminal, SqmCreationState creationState) {
        if (this.dereferenced) {
            return;
        }
        SqmCreationHelper.resolveAsLhs(this.getLhs(), this, subNavigable, isSubReferenceTerminal, creationState);
        this.dereferenced = true;
    }

    @Override
    public EntityValuedNavigable getExpressableType() {
        return this.getReferencedNavigable();
    }

    public Supplier<? extends EntityValuedNavigable> getInferableType() {
        return this::getReferencedNavigable;
    }

    @Override
    public EntityJavaDescriptor getJavaTypeDescriptor() {
        return this.getReferencedNavigable().getJavaTypeDescriptor();
    }
}

