/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.function.Supplier;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmIndexedCollectionAccessPath
implements SqmPath {
    private final SqmPath pluralDomainPath;
    private final SqmExpression selectorExpression;
    private final PersistentCollectionDescriptor collectionDescriptor;
    private String explicitAlias;

    public SqmIndexedCollectionAccessPath(SqmPath pluralDomainPath, SqmExpression selectorExpression) {
        this.pluralDomainPath = pluralDomainPath;
        this.selectorExpression = selectorExpression;
        this.collectionDescriptor = pluralDomainPath.as(PluralValuedNavigable.class).getCollectionDescriptor();
    }

    public SqmExpression getSelectorExpression() {
        return this.selectorExpression;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return null;
    }

    @Override
    public Navigable<?> getReferencedNavigable() {
        return this.collectionDescriptor.getElementDescriptor();
    }

    @Override
    public SqmPath getLhs() {
        return this.pluralDomainPath;
    }

    @Override
    public String getExplicitAlias() {
        return this.explicitAlias;
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.explicitAlias = explicitAlias;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        Navigable subNavigable = ((NavigableContainer)((Object)this.collectionDescriptor.getElementDescriptor())).findNavigable(name);
        return subNavigable.createSqmExpression(this, creationState);
    }

    @Override
    public ExpressableType getExpressableType() {
        return this.getReferencedNavigable();
    }

    @Override
    public Supplier<? extends ExpressableType> getInferableType() {
        return this::getReferencedNavigable;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitIndexedPluralAccessPath(this);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getReferencedNavigable().getJavaTypeDescriptor();
    }

    public Type.PersistenceType getPersistenceType() {
        return this.getReferencedNavigable().getPersistenceType();
    }

    public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }
}

