/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.function.Supplier;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.sqm.SemanticException;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmMaxElementPath
extends AbstractSqmSpecificPluralPartPath {
    public static final String NAVIGABLE_NAME = "{max-element}";

    public SqmMaxElementPath(SqmPath pluralDomainPath) {
        super(pluralDomainPath.getNavigablePath().append(NAVIGABLE_NAME), pluralDomainPath);
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        if (this.getReferencedNavigable() instanceof NavigableContainer) {
            Navigable subNavigable = ((NavigableContainer)this.getReferencedNavigable()).findNavigable(name);
            this.getPluralDomainPath().prepareForSubNavigableReference(subNavigable, isTerminal, creationState);
            return subNavigable.createSqmExpression(this, creationState);
        }
        throw new SemanticException("Collection element cannot be de-referenced : " + this.getPluralDomainPath().getNavigablePath());
    }

    @Override
    public Navigable<?> getReferencedNavigable() {
        return this.getCollectionDescriptor().getElementDescriptor();
    }

    @Override
    public ExpressableType getExpressableType() {
        return this.getReferencedNavigable();
    }

    @Override
    public Supplier<? extends ExpressableType> getInferableType() {
        return this::getReferencedNavigable;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitMaxElementPath(this);
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getReferencedNavigable().getJavaTypeDescriptor();
    }

    public Type.PersistenceType getPersistenceType() {
        return this.getReferencedNavigable().getPersistenceType();
    }

    public Class getJavaType() {
        return this.getJavaTypeDescriptor().getJavaType();
    }
}

