/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SemanticException;
import org.hibernate.query.sqm.produce.SqmCreationHelper;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;

public interface SqmPath
extends SqmExpression,
SemanticPathPart,
ExpressableType {
    public NavigablePath getNavigablePath();

    public Navigable<?> getReferencedNavigable();

    public SqmPath getLhs();

    default public SqmRoot findRoot() {
        SqmPath lhs = this.getLhs();
        if (lhs != null) {
            return lhs.findRoot();
        }
        throw new ParsingException("Could not find root");
    }

    public String getExplicitAlias();

    public void setExplicitAlias(String var1);

    @Override
    default public SqmPath resolveIndexedAccess(SqmExpression selector, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        if (this.getReferencedNavigable() instanceof PluralValuedNavigable) {
            throw new NotYetImplementedFor6Exception();
        }
        throw new SemanticException("Non-plural path [" + currentContextKey + "] cannot be index-accessed");
    }

    default public void prepareForSubNavigableReference(Navigable subNavigable, boolean isSubReferenceTerminal, SqmCreationState creationState) {
        SqmCreationHelper.resolveAsLhs(this.getLhs(), this, subNavigable, isSubReferenceTerminal, creationState);
    }

    default public <T> T as(Class<T> targetType) {
        if (targetType.isInstance(this)) {
            return (T)this;
        }
        if (Navigable.class.isAssignableFrom(targetType)) {
            return this.getReferencedNavigable().as(targetType);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "`%s` cannot be treated as `%s`", this.getClass().getName(), targetType.getName()));
    }

    default public <T> T as(Class<T> targetType, Supplier<RuntimeException> exceptionSupplier) {
        try {
            return this.as(targetType);
        }
        catch (IllegalArgumentException e) {
            throw exceptionSupplier.get();
        }
    }
}

