/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.function.Supplier;
import org.hibernate.query.sqm.tree.expression.InferableTypeSqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public abstract class AbstractInferableTypeSqmExpression
implements InferableTypeSqmExpression {
    private ExpressableType inherentType;
    private Supplier<? extends ExpressableType> typeInference;

    public AbstractInferableTypeSqmExpression(ExpressableType inherentType) {
        this.inherentType = inherentType;
    }

    protected void setInherentType(ExpressableType inherentType) {
        if (this.inherentType == null) {
            this.inherentType = inherentType;
        }
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getExpressableType().getJavaTypeDescriptor();
    }

    @Override
    public ExpressableType getExpressableType() {
        return this.getInferableType().get();
    }

    @Override
    public Supplier<? extends ExpressableType> getInferableType() {
        return () -> {
            ExpressableType inferredType = this.typeInference != null ? this.typeInference.get() : null;
            return this.firstNonStandardBasicType(inferredType, this.inherentType);
        };
    }

    private ExpressableType firstNonStandardBasicType(ExpressableType ... types) {
        ExpressableType firstNonNull = null;
        for (ExpressableType type : types) {
            if (type == null) continue;
            if (!(type instanceof StandardSpiBasicTypes.StandardBasicType)) {
                return type;
            }
            if (firstNonNull != null) continue;
            firstNonNull = type;
        }
        return firstNonNull;
    }

    @Override
    public void impliedType(Supplier<? extends ExpressableType> inference) {
        this.typeInference = inference;
    }
}

