/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.descriptor.java.internal.JdbcDateJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcTimeJavaDescriptor;
import org.hibernate.type.descriptor.java.internal.JdbcTimestampJavaDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class LiteralHelper {
    public static final SqmLiteral<Integer> INTEGER_ZERO = new SqmLiteral<Integer>(0, StandardSpiBasicTypes.INTEGER);
    public static final SqmLiteral<Integer> INTEGER_ONE = new SqmLiteral<Integer>(1, StandardSpiBasicTypes.INTEGER);

    public static SqmLiteral<Timestamp> timestampLiteralFrom(String literalText, SqmCreationState creationState) {
        Timestamp literal = Timestamp.valueOf(LocalDateTime.from(JdbcTimestampJavaDescriptor.FORMATTER.parse(literalText)));
        return new SqmLiteral<Timestamp>(literal, creationState.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Timestamp.class));
    }

    public static SqmLiteral<Date> dateLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalDate localDate = LocalDate.from(JdbcDateJavaDescriptor.FORMATTER.parse(literalText));
        Date literal = new Date(localDate.toEpochDay());
        return new SqmLiteral<Date>(literal, creationState.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Date.class));
    }

    public static SqmLiteral<Time> timeLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalTime localTime = LocalTime.from(JdbcTimeJavaDescriptor.FORMATTER.parse(literalText));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, creationState.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Time.class));
    }
}

