/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.function.Supplier;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class SqmBinaryArithmetic
implements SqmExpression {
    private final BinaryArithmeticOperator operator;
    private final SqmExpression lhsOperand;
    private final SqmExpression rhsOperand;
    private BasicValuedExpressableType expressionType;

    public SqmBinaryArithmetic(SqmExpression lhsOperand, BinaryArithmeticOperator operator, SqmExpression rhsOperand, BasicValuedExpressableType expressionType) {
        this.operator = operator;
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.expressionType = expressionType;
    }

    @Override
    public BasicJavaDescriptor getJavaTypeDescriptor() {
        return this.expressionType.getJavaTypeDescriptor();
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBinaryArithmeticExpression(this);
    }

    public SqmExpression getLeftHandOperand() {
        return this.lhsOperand;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public SqmExpression getRightHandOperand() {
        return this.rhsOperand;
    }

    @Override
    public BasicValuedExpressableType getExpressableType() {
        return this.expressionType;
    }

    public Supplier<? extends BasicValuedExpressableType> getInferableType() {
        return this::getExpressableType;
    }

    @Override
    public String asLoggableText() {
        return this.getOperator().toLoggableText(this.lhsOperand.asLoggableText(), this.rhsOperand.asLoggableText());
    }
}

