/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.AbstractInferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.InferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;

public class SqmCaseSearched
extends AbstractInferableTypeSqmExpression {
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private SqmExpression otherwise;

    public SqmCaseSearched() {
        this(null);
    }

    public SqmCaseSearched(BasicValuedExpressableType inherentType) {
        super(inherentType);
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression getOtherwise() {
        return this.otherwise;
    }

    public void when(SqmPredicate predicate, SqmExpression result) {
        this.whenFragments.add(new WhenFragment(predicate, result));
        this.setInherentType(result.getExpressableType());
    }

    public void otherwise(SqmExpression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.setInherentType(otherwiseExpression.getExpressableType());
    }

    @Override
    public void impliedType(Supplier<? extends ExpressableType> inference) {
        super.impliedType(inference);
        for (WhenFragment whenFragment : this.whenFragments) {
            if (!(whenFragment.getResult() instanceof InferableTypeSqmExpression)) continue;
            ((InferableTypeSqmExpression)whenFragment.getResult()).impliedType(inference);
        }
        if (this.otherwise != null && this.otherwise instanceof InferableTypeSqmExpression) {
            ((InferableTypeSqmExpression)this.otherwise).impliedType(inference);
        }
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSearchedCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<searched-case>";
    }

    public static class WhenFragment {
        private final SqmPredicate predicate;
        private final SqmExpression result;

        public WhenFragment(SqmPredicate predicate, SqmExpression result) {
            this.predicate = predicate;
            this.result = result;
        }

        public SqmPredicate getPredicate() {
            return this.predicate;
        }

        public SqmExpression getResult() {
            return this.result;
        }
    }
}

