/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.AbstractInferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.InferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;

public class SqmCaseSimple
extends AbstractInferableTypeSqmExpression {
    private final SqmExpression fixture;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private SqmExpression otherwise;

    public SqmCaseSimple(SqmExpression fixture) {
        this(fixture, null);
    }

    public SqmCaseSimple(SqmExpression fixture, ExpressableType inherentType) {
        super(inherentType);
        this.fixture = fixture;
    }

    public SqmExpression getFixture() {
        return this.fixture;
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(SqmExpression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.setInherentType(otherwiseExpression.getExpressableType());
    }

    public void when(SqmExpression test, SqmExpression result) {
        this.whenFragments.add(new WhenFragment(test, result));
        this.setInherentType(result.getExpressableType());
    }

    @Override
    public BasicValuedExpressableType getExpressableType() {
        return (BasicValuedExpressableType)this.getInferableType().get();
    }

    @Override
    public void impliedType(Supplier<? extends ExpressableType> inference) {
        super.impliedType(inference);
        for (WhenFragment whenFragment : this.whenFragments) {
            if (!(whenFragment.getResult() instanceof InferableTypeSqmExpression)) continue;
            ((InferableTypeSqmExpression)whenFragment.getResult()).impliedType(inference);
        }
        if (this.otherwise != null && this.otherwise instanceof InferableTypeSqmExpression) {
            ((InferableTypeSqmExpression)this.otherwise).impliedType(inference);
        }
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSimpleCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<simple-case>";
    }

    public static class WhenFragment {
        private final SqmExpression checkValue;
        private final SqmExpression result;

        public WhenFragment(SqmExpression checkValue, SqmExpression result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public SqmExpression getCheckValue() {
            return this.checkValue;
        }

        public SqmExpression getResult() {
            return this.result;
        }
    }
}

