/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.function.Supplier;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmConcat
implements SqmExpression {
    private final SqmExpression lhsOperand;
    private final SqmExpression rhsOperand;
    private final BasicValuedExpressableType resultType;

    public SqmConcat(SqmExpression lhsOperand, SqmExpression rhsOperand) {
        this(lhsOperand, rhsOperand, (BasicValuedExpressableType)lhsOperand.getExpressableType());
    }

    public SqmConcat(SqmExpression lhsOperand, SqmExpression rhsOperand, BasicValuedExpressableType resultType) {
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.resultType = resultType;
    }

    public SqmExpression getLeftHandOperand() {
        return this.lhsOperand;
    }

    public SqmExpression getRightHandOperand() {
        return this.rhsOperand;
    }

    @Override
    public BasicValuedExpressableType getExpressableType() {
        return this.resultType;
    }

    public Supplier<? extends BasicValuedExpressableType> getInferableType() {
        return () -> {
            BasicValuedExpressableType inferableType;
            Supplier<? extends ExpressableType> inference = this.lhsOperand.getInferableType();
            if (inference != null && (inferableType = (BasicValuedExpressableType)inference.get()) != null) {
                return inferableType;
            }
            inference = this.rhsOperand.getInferableType();
            if (inference != null && (inferableType = (BasicValuedExpressableType)inference.get()) != null) {
                return inferableType;
            }
            return this.resultType;
        };
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitConcatExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<concat>";
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getExpressableType().getJavaTypeDescriptor();
    }
}

