/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.QueryException;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmTuple
implements SqmExpression {
    private final List<SqmExpression> groupedExpressions;

    public SqmTuple(SqmExpression groupedExpression) {
        this(Collections.singletonList(groupedExpression));
    }

    public SqmTuple(SqmExpression ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions));
    }

    public SqmTuple(List<SqmExpression> groupedExpressions) {
        if (groupedExpressions.isEmpty()) {
            throw new QueryException("tuple grouping cannot be constructed over zero expressions");
        }
        this.groupedExpressions = groupedExpressions;
    }

    @Override
    public ExpressableType getExpressableType() {
        Optional<SqmExpression> first = this.groupedExpressions.stream().filter(sqmExpression -> sqmExpression.getExpressableType() != null).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        return first.get().getExpressableType();
    }

    public Supplier<ExpressableType> getInferableType() {
        return null;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return null;
    }

    @Override
    public String asLoggableText() {
        return null;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getExpressableType().getJavaTypeDescriptor();
    }
}

