/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.function.Supplier;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.AbstractInferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;

public class SqmUnaryOperation
extends AbstractInferableTypeSqmExpression {
    private final UnaryArithmeticOperator operation;
    private final SqmExpression operand;

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression operand) {
        this(operation, operand, (BasicValuedExpressableType)operand.getExpressableType());
    }

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression operand, BasicValuedExpressableType inherentType) {
        super(inherentType);
        this.operation = operation;
        this.operand = operand;
    }

    public SqmExpression getOperand() {
        return this.operand;
    }

    public UnaryArithmeticOperator getOperation() {
        return this.operation;
    }

    @Override
    public BasicValuedExpressableType getExpressableType() {
        return (BasicValuedExpressableType)super.getExpressableType();
    }

    public Supplier<? extends BasicValuedExpressableType> getInferableType() {
        return super.getInferableType();
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitUnaryOperationExpression(this);
    }

    @Override
    public String asLoggableText() {
        return (this.operation == UnaryArithmeticOperator.UNARY_MINUS ? (char)'-' : '+') + this.operand.asLoggableText();
    }
}

