/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;

public class SqmCastFunction
extends AbstractSqmFunction
implements SqmFunction {
    public static final String NAME = "cast";
    private final SqmExpression expressionToCast;
    private final String explicitSqlCastTarget;

    public SqmCastFunction(SqmExpression expressionToCast, AllowableFunctionReturnType castTargetType) {
        this(expressionToCast, castTargetType, null);
    }

    public SqmCastFunction(SqmExpression expressionToCast, AllowableFunctionReturnType castTargetType, String explicitSqlCastTarget) {
        super(castTargetType);
        this.expressionToCast = expressionToCast;
        this.explicitSqlCastTarget = explicitSqlCastTarget;
    }

    public SqmExpression getExpressionToCast() {
        return this.expressionToCast;
    }

    public String getExplicitSqlCastTarget() {
        return this.explicitSqlCastTarget;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitCastFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "CAST(" + this.expressionToCast.asLoggableText() + ")";
    }
}

