/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmCoalesceFunction
implements SqmFunction {
    public static final String NAME = "coalesce";
    private AllowableFunctionReturnType resultType;
    private List<SqmExpression> arguments = new ArrayList<SqmExpression>();

    @Override
    public AllowableFunctionReturnType getExpressableType() {
        return this.resultType;
    }

    @Override
    public Supplier<? extends AllowableFunctionReturnType> getInferableType() {
        return this::getExpressableType;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        if (this.getExpressableType() == null) {
            return null;
        }
        return this.getExpressableType().getJavaTypeDescriptor();
    }

    public List<SqmExpression> getArguments() {
        return this.arguments;
    }

    public void value(SqmExpression expression) {
        this.arguments.add(expression);
        if (this.resultType == null) {
            this.resultType = (AllowableFunctionReturnType)expression.getExpressableType();
        }
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitCoalesceFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "coalesce(...)";
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }
}

