/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.List;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;

public class SqmConcatFunction
extends AbstractSqmFunction {
    public static final String NAME = "concat";
    private final List<SqmExpression> expressions;

    public SqmConcatFunction(BasicValuedExpressableType resultType, List<SqmExpression> expressions) {
        super(resultType);
        this.expressions = expressions;
        assert (expressions != null);
        assert (expressions.size() >= 2);
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    public List<SqmExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitConcatFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "CONCAT(...)";
    }
}

