/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;

public class SqmExtractFunction
extends AbstractSqmFunction {
    public static final String NAME = "extract";
    private final SqmExpression unitToExtract;
    private final SqmExpression extractionSource;

    public SqmExtractFunction(SqmExpression unitToExtract, SqmExpression extractionSource, AllowableFunctionReturnType resultType) {
        super(resultType);
        this.unitToExtract = unitToExtract;
        this.extractionSource = extractionSource;
    }

    public SqmExpression getUnitToExtract() {
        return this.unitToExtract;
    }

    public SqmExpression getExtractionSource() {
        return this.extractionSource;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitExtractFunction(this);
    }

    @Override
    public String asLoggableText() {
        return String.format(Locale.ROOT, "%s( %s from %s )", NAME, this.getUnitToExtract().asLoggableText(), this.getExtractionSource().asLoggableText());
    }
}

