/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.List;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmNonStandardFunction;

public class SqmGenericFunction
extends AbstractSqmFunction
implements SqmNonStandardFunction {
    private final String functionName;
    private final List<SqmExpression> arguments;

    public SqmGenericFunction(String functionName, AllowableFunctionReturnType resultType, List<SqmExpression> arguments) {
        super(resultType);
        this.functionName = functionName;
        this.arguments = arguments;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public List<SqmExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitGenericFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "function(" + this.getFunctionName() + " ...)";
    }
}

