/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmNonStandardFunction;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.SqlTreeException;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmJdbcFunctionEscapeWrapper
extends SelfRenderingSqmFunction
implements SqmNonStandardFunction,
SqlAstFunctionProducer,
SelfRenderingFunctionSupport {
    private final SqmFunction wrappedSqmFunction;

    public SqmJdbcFunctionEscapeWrapper(SqmFunction wrappedSqmFunction, AllowableFunctionReturnType impliedResultType) {
        super(null, Collections.singletonList(wrappedSqmFunction), impliedResultType);
        this.wrappedSqmFunction = wrappedSqmFunction;
    }

    public SqmJdbcFunctionEscapeWrapper(SqmFunction wrappedSqmFunction) {
        super(null, Collections.singletonList(wrappedSqmFunction), wrappedSqmFunction.getExpressableType());
        this.wrappedSqmFunction = wrappedSqmFunction;
    }

    @Override
    public String getFunctionName() {
        return this.wrappedSqmFunction.getFunctionName();
    }

    @Override
    public boolean hasArguments() {
        return this.wrappedSqmFunction.hasArguments();
    }

    @Override
    public SelfRenderingFunctionSupport getRenderingSupport() {
        return this;
    }

    @Override
    public String asLoggableText() {
        return "wrapped-function[ " + this.wrappedSqmFunction.asLoggableText() + " ]";
    }

    @Override
    public void render(SqlAppender sqlAppender, List<Expression> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        if (sqlAstArguments.isEmpty()) {
            throw new SqlTreeException("JDBC function escape wrapper had no SQL AST form of its wrapped function as argument");
        }
        if (sqlAstArguments.size() > 1) {
            throw new SqlTreeException("JDBC function escape wrapper had multiple arguments; should have just one - the wrapped function");
        }
        sqlAppender.appendSql("{fn ");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.appendSql("}");
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getExpressableType().getJavaTypeDescriptor();
    }
}

