/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;

public class SqmLengthFunction
extends AbstractSqmFunction {
    public static final String NAME = "length";
    private final SqmExpression argument;

    public SqmLengthFunction(SqmExpression argument, AllowableFunctionReturnType resultType) {
        super(resultType);
        this.argument = argument;
    }

    public SqmExpression getArgument() {
        return this.argument;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitLengthFunction(this);
    }

    @Override
    public String asLoggableText() {
        return String.format(Locale.ROOT, "%s( %s )", NAME, this.argument.asLoggableText());
    }
}

