/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;

public class SqmLocateFunction
extends AbstractSqmFunction {
    public static final String NAME = "locate";
    private final SqmExpression patternString;
    private final SqmExpression stringToSearch;
    private final SqmExpression startPosition;

    public SqmLocateFunction(SqmExpression patternString, SqmExpression stringToSearch, SqmExpression startPosition, AllowableFunctionReturnType resultType) {
        super(resultType);
        this.patternString = patternString;
        this.stringToSearch = stringToSearch;
        this.startPosition = startPosition;
        assert (patternString != null);
        assert (stringToSearch != null);
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    public SqmExpression getPatternString() {
        return this.patternString;
    }

    public SqmExpression getStringToSearch() {
        return this.stringToSearch;
    }

    public SqmExpression getStartPosition() {
        return this.startPosition;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitLocateFunction(this);
    }

    @Override
    public String asLoggableText() {
        return String.format(Locale.ROOT, "%s(%s, %s, %s)", NAME, this.patternString.asLoggableText(), this.stringToSearch.asLoggableText(), this.startPosition == null ? "<no-start-position>" : this.startPosition.asLoggableText());
    }
}

