/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;

public class SqmModFunction
extends AbstractSqmFunction {
    public static final String NAME = "mod";
    private final SqmExpression dividend;
    private final SqmExpression divisor;

    public SqmModFunction(SqmExpression dividend, SqmExpression divisor, AllowableFunctionReturnType resultType) {
        super(resultType);
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public SqmExpression getDividend() {
        return this.dividend;
    }

    public SqmExpression getDivisor() {
        return this.divisor;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitModFunction(this);
    }

    @Override
    public String asLoggableText() {
        return String.format(Locale.ROOT, "%s( %s, %s )", NAME, this.dividend.asLoggableText(), this.divisor.asLoggableText());
    }
}

