/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;

public class SqmSubstringFunction
extends AbstractSqmFunction {
    public static final String NAME = "substring";
    public static final String ALT_NAME = "substr";
    private final SqmExpression source;
    private final SqmExpression startPosition;
    private final SqmExpression length;

    public SqmSubstringFunction(BasicValuedExpressableType resultType, SqmExpression source, SqmExpression startPosition, SqmExpression length) {
        super(resultType);
        this.source = source;
        this.startPosition = startPosition;
        this.length = length;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    public SqmExpression getSource() {
        return this.source;
    }

    public SqmExpression getStartPosition() {
        return this.startPosition;
    }

    public SqmExpression getLength() {
        return this.length;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSubstringFunction(this);
    }

    @Override
    public String asLoggableText() {
        StringBuilder buff = new StringBuilder(this.getFunctionName()).append('(').append(this.getSource().asLoggableText());
        if (this.getStartPosition() != null) {
            buff.append(", ").append(this.getStartPosition().asLoggableText());
        }
        if (this.getLength() != null) {
            buff.append(", ").append(this.getLength().asLoggableText());
        }
        return buff.append(")").toString();
    }
}

