/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression.function;

import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.function.AbstractSqmFunction;
import org.hibernate.sql.TrimSpecification;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;

public class SqmTrimFunction
extends AbstractSqmFunction {
    public static final String NAME = "trim";
    private final TrimSpecification specification;
    private final SqmExpression trimCharacter;
    private final SqmExpression source;

    public SqmTrimFunction(BasicValuedExpressableType resultType, TrimSpecification specification, SqmExpression trimCharacter, SqmExpression source) {
        super(resultType);
        this.specification = specification;
        this.trimCharacter = trimCharacter;
        this.source = source;
        assert (specification != null);
        assert (trimCharacter != null);
        assert (source != null);
    }

    public TrimSpecification getSpecification() {
        return this.specification;
    }

    public SqmExpression getTrimCharacter() {
        return this.trimCharacter;
    }

    public SqmExpression getSource() {
        return this.source;
    }

    @Override
    public String getFunctionName() {
        return NAME;
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitTrimFunction(this);
    }

    @Override
    public String asLoggableText() {
        return "TRIM(" + this.specification.name() + " '" + this.trimCharacter.asLoggableText() + "' FROM " + this.source.asLoggableText() + ")";
    }
}

