/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.UsageDetails;
import org.hibernate.query.sqm.tree.from.UsageDetailsImpl;

public abstract class AbstractSqmFrom
implements SqmFrom {
    private final NavigablePath navigablePath;
    private final NavigableContainer referencedNavigable;
    private String alias;
    private List<SqmJoin> joins;
    private final UsageDetailsImpl usageDetails = new UsageDetailsImpl(this);

    protected AbstractSqmFrom(NavigablePath navigablePath, NavigableContainer referencedNavigable, String alias) {
        this.navigablePath = navigablePath;
        this.referencedNavigable = referencedNavigable;
        this.alias = alias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigableContainer<?> getReferencedNavigable() {
        return this.referencedNavigable;
    }

    @Override
    public String getExplicitAlias() {
        return this.alias;
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.alias = explicitAlias;
    }

    @Override
    public UsageDetails getUsageDetails() {
        return this.usageDetails;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
        NavigablePath subNavPath = this.getNavigablePath().append(name);
        return creationState.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(subNavPath, snp -> {
            Navigable navigable = this.getReferencedNavigable().findNavigable(name);
            if (navigable == null) {
                throw UnknownPathException.unknownSubPath(this, name);
            }
            return navigable.createSqmExpression(this, creationState);
        });
    }

    @Override
    public boolean hasJoins() {
        return this.joins != null && !this.joins.isEmpty();
    }

    @Override
    public List<SqmJoin> getJoins() {
        return this.joins == null ? Collections.emptyList() : Collections.unmodifiableList(this.joins);
    }

    @Override
    public void addJoin(SqmJoin join) {
        if (this.joins == null) {
            this.joins = new ArrayList<SqmJoin>();
        }
        this.joins.add(join);
    }

    @Override
    public void visitJoins(Consumer<SqmJoin> consumer) {
        if (this.joins != null) {
            this.joins.forEach(consumer);
        }
    }
}

