/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.util.function.Supplier;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.produce.SqmCreationHelper;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.from.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class SqmNavigableJoin
extends AbstractSqmJoin
implements SqmQualifiedJoin {
    private static final Logger log = Logger.getLogger(SqmNavigableJoin.class);
    private final SqmFrom lhs;
    private final boolean fetched;
    private SqmPredicate onClausePredicate;

    public SqmNavigableJoin(SqmFrom lhs, Joinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, SqmCreationState creationState) {
        super(SqmCreationHelper.buildSubNavigablePath(lhs.getNavigablePath(), joinedNavigable.getNavigableName(), alias), joinedNavigable, alias, joinType);
        this.lhs = lhs;
        this.fetched = fetched;
    }

    @Override
    public SqmFrom getLhs() {
        return this.lhs;
    }

    @Override
    public Joinable<?> getReferencedNavigable() {
        return (Joinable)super.getReferencedNavigable();
    }

    @Override
    public NavigableContainer getExpressableType() {
        return this.getReferencedNavigable();
    }

    public Supplier<? extends NavigableContainer> getInferableType() {
        return () -> this.getReferencedNavigable();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getReferencedNavigable().getJavaTypeDescriptor();
    }

    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public SqmPredicate getJoinPredicate() {
        return this.onClausePredicate;
    }

    @Override
    public void setJoinPredicate(SqmPredicate predicate) {
        log.tracef("Setting join predicate [%s] (was [%s])", (Object)predicate.toString(), (Object)(this.onClausePredicate == null ? "<null>" : this.onClausePredicate.toString()));
        this.onClausePredicate = predicate;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitQualifiedAttributeJoinFromElement(this);
    }

    public Type.PersistenceType getPersistenceType() {
        return this.getReferencedNavigable().getPersistenceType();
    }

    public Class getJavaType() {
        return this.getReferencedNavigable().getJavaType();
    }
}

