/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.spi.BasicType;

public class BooleanExpressionSqmPredicate
implements SqmPredicate {
    private final SqmExpression booleanExpression;

    public BooleanExpressionSqmPredicate(SqmExpression booleanExpression) {
        assert (booleanExpression.getExpressableType() != null);
        Class expressionJavaType = ((BasicType)booleanExpression.getExpressableType()).getJavaType();
        assert (Boolean.TYPE.equals(expressionJavaType) || Boolean.class.equals(expressionJavaType));
        this.booleanExpression = booleanExpression;
    }

    public SqmExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBooleanExpressionPredicate(this);
    }
}

