/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InSqmPredicate;

public class InListSqmPredicate
extends AbstractNegatableSqmPredicate
implements InSqmPredicate {
    private final SqmExpression testExpression;
    private final List<SqmExpression> listExpressions;

    public InListSqmPredicate(SqmExpression testExpression) {
        this(testExpression, new ArrayList<SqmExpression>());
    }

    public InListSqmPredicate(SqmExpression testExpression, SqmExpression ... listExpressions) {
        this(testExpression, ArrayHelper.toExpandableList(listExpressions));
    }

    public InListSqmPredicate(SqmExpression testExpression, List<SqmExpression> listExpressions) {
        this(testExpression, listExpressions, false);
    }

    public InListSqmPredicate(SqmExpression testExpression, List<SqmExpression> listExpressions, boolean negated) {
        super(negated);
        this.testExpression = testExpression;
        this.listExpressions = listExpressions;
    }

    @Override
    public SqmExpression getTestExpression() {
        return this.testExpression;
    }

    public List<SqmExpression> getListExpressions() {
        return this.listExpressions;
    }

    public void addExpression(SqmExpression expression) {
        this.listExpressions.add(expression);
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitInListPredicate(this);
    }
}

