/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.function.Supplier;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.InferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.NegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;

public class SqmComparisonPredicate
implements SqmPredicate,
NegatableSqmPredicate {
    private final SqmExpression leftHandExpression;
    private ComparisonOperator operator;
    private final SqmExpression rightHandExpression;

    public SqmComparisonPredicate(SqmExpression leftHandExpression, ComparisonOperator operator, SqmExpression rightHandExpression) {
        Supplier<? extends ExpressableType> inference;
        this.leftHandExpression = leftHandExpression;
        this.rightHandExpression = rightHandExpression;
        this.operator = operator;
        if (rightHandExpression instanceof InferableTypeSqmExpression && (inference = leftHandExpression.getInferableType()) != null) {
            ((InferableTypeSqmExpression)rightHandExpression).impliedType(inference);
        }
        if (leftHandExpression instanceof InferableTypeSqmExpression && (inference = rightHandExpression.getInferableType()) != null) {
            ((InferableTypeSqmExpression)leftHandExpression).impliedType(rightHandExpression.getInferableType());
        }
    }

    public SqmExpression getLeftHandExpression() {
        return this.leftHandExpression;
    }

    public SqmExpression getRightHandExpression() {
        return this.rightHandExpression;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public void negate() {
        this.operator = this.operator.negated();
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitComparisonPredicate(this);
    }
}

