/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmAliasedExpressionContainer;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.sql.ast.tree.expression.instantiation.DynamicInstantiationNature;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class SqmDynamicInstantiation
implements SqmSelectableNode,
SqmAliasedExpressionContainer<SqmDynamicInstantiationArgument> {
    private static final Logger log = Logger.getLogger(SqmDynamicInstantiation.class);
    private final SqmDynamicInstantiationTarget instantiationTarget;
    private List<SqmDynamicInstantiationArgument> arguments;

    public static SqmDynamicInstantiation forClassInstantiation(JavaTypeDescriptor targetJavaType) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.CLASS, targetJavaType));
    }

    public static SqmDynamicInstantiation forMapInstantiation(JavaTypeDescriptor<Map> mapJavaTypeDescriptor) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.MAP, mapJavaTypeDescriptor));
    }

    public static SqmDynamicInstantiation forListInstantiation(JavaTypeDescriptor<List> listJavaTypeDescriptor) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.LIST, listJavaTypeDescriptor));
    }

    private SqmDynamicInstantiation(SqmDynamicInstantiationTarget instantiationTarget) {
        this.instantiationTarget = instantiationTarget;
    }

    public SqmDynamicInstantiationTarget getInstantiationTarget() {
        return this.instantiationTarget;
    }

    public List<SqmDynamicInstantiationArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getInstantiationTarget().getTargetTypeDescriptor();
    }

    @Override
    public String asLoggableText() {
        return "<new " + this.instantiationTarget.getJavaType().getName() + ">";
    }

    public void addArgument(SqmDynamicInstantiationArgument argument) {
        if (this.instantiationTarget.getNature() == DynamicInstantiationNature.LIST) {
            if (argument.getAlias() != null) {
                log.debugf("Argument [%s] for dynamic List instantiation declared an 'injection alias' [%s] but such aliases are ignored for dynamic List instantiations", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
            }
        } else if (this.instantiationTarget.getNature() == DynamicInstantiationNature.MAP) {
            log.warnf("Argument [%s] for dynamic Map instantiation did not declare an 'injection alias' [%s] but such aliases are needed for dynamic Map instantiations; will likely cause problems later translating sqm", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList<SqmDynamicInstantiationArgument>();
        }
        this.arguments.add(argument);
    }

    @Override
    public SqmDynamicInstantiationArgument add(SqmExpression expression, String alias) {
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(expression, alias);
        this.addArgument(argument);
        return argument;
    }

    @Override
    public void add(SqmDynamicInstantiationArgument aliasExpression) {
        this.addArgument(aliasExpression);
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitDynamicInstantiation(this);
    }

    public SqmDynamicInstantiation makeShallowCopy() {
        return new SqmDynamicInstantiation(this.getInstantiationTarget());
    }

    private static class DynamicInstantiationTargetImpl
    implements SqmDynamicInstantiationTarget {
        private final DynamicInstantiationNature nature;
        private final JavaTypeDescriptor javaTypeDescriptor;

        public DynamicInstantiationTargetImpl(DynamicInstantiationNature nature, JavaTypeDescriptor javaTypeDescriptor) {
            this.nature = nature;
            this.javaTypeDescriptor = javaTypeDescriptor;
        }

        @Override
        public DynamicInstantiationNature getNature() {
            return this.nature;
        }

        public JavaTypeDescriptor getTargetTypeDescriptor() {
            return this.javaTypeDescriptor;
        }
    }
}

