/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmGroupByClause {
    private List<SqmGrouping> groupings;

    public List<SqmGrouping> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(List<SqmGrouping> groupings) {
        this.groupings = groupings;
    }

    public void addGrouping(SqmGrouping grouping) {
        if (this.groupings == null) {
            this.groupings = new ArrayList<SqmGrouping>();
        }
        this.groupings.add(grouping);
    }

    public void addGrouping(SqmExpression groupExpression) {
        this.addGrouping(new SqmGrouping(groupExpression, null));
    }

    public void addGrouping(SqmExpression groupExpression, String collation) {
        this.addGrouping(new SqmGrouping(groupExpression, collation));
    }

    public void visitGroupings(Consumer<SqmGrouping> consumer) {
        if (this.groupings != null) {
            this.groupings.forEach(consumer);
        }
    }

    public static class SqmGrouping {
        private SqmExpression expression;
        private String collation;

        public SqmGrouping() {
        }

        public SqmGrouping(SqmExpression expression, String collation) {
            this.expression = expression;
            this.collation = collation;
        }

        public SqmExpression getExpression() {
            return this.expression;
        }

        public void setExpression(SqmExpression expression) {
            this.expression = expression;
        }

        public String getCollation() {
            return this.collation;
        }

        public void setCollation(String collation) {
            this.collation = collation;
        }
    }
}

