/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmAliasedExpressionContainer;
import org.hibernate.query.sqm.tree.select.SqmSelection;

public class SqmSelectClause
implements SqmAliasedExpressionContainer<SqmSelection> {
    private final boolean distinct;
    private List<SqmSelection> selections;

    public SqmSelectClause(boolean distinct) {
        this.distinct = distinct;
    }

    public SqmSelectClause(boolean distinct, List<SqmSelection> selections) {
        this.distinct = distinct;
        this.selections = selections;
    }

    public SqmSelectClause(boolean distinct, SqmSelection ... selections) {
        this(distinct, Arrays.asList(selections));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SqmSelection> getSelections() {
        if (this.selections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.selections);
    }

    public void addSelection(SqmSelection selection) {
        if (this.selections == null) {
            this.selections = new ArrayList<SqmSelection>();
        }
        this.selections.add(selection);
    }

    @Override
    public SqmSelection add(SqmExpression expression, String alias) {
        SqmSelection selection = new SqmSelection(expression, alias);
        this.addSelection(selection);
        return selection;
    }

    @Override
    public void add(SqmSelection aliasExpression) {
        this.addSelection(aliasExpression);
    }
}

