/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.InstantiationException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.jboss.logging.Logger;

public class FallbackBeanInstanceProducer
implements BeanInstanceProducer {
    private static final Logger log = Logger.getLogger(FallbackBeanInstanceProducer.class);
    public static final FallbackBeanInstanceProducer INSTANCE = new FallbackBeanInstanceProducer();

    private FallbackBeanInstanceProducer() {
    }

    @Override
    public <B> B produceBeanInstance(Class<B> beanType) {
        Constructor<B> ctor;
        log.tracef("Creating ManagedBean(%s) using direct instantiation", (Object)beanType.getName());
        try {
            ctor = beanType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Could not locate no-arg constructor for bean : " + beanType.getName());
        }
        ReflectHelper.ensureAccessibility(ctor);
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate managed bean directly", beanType, e);
        }
    }

    @Override
    public <B> B produceBeanInstance(String name, Class<B> beanType) {
        return this.produceBeanInstance(beanType);
    }
}

