/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.result.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.query.sql.internal.ResultSetMappingDescriptorUndefined;
import org.hibernate.result.NoMoreOutputsException;
import org.hibernate.result.Output;
import org.hibernate.result.Outputs;
import org.hibernate.result.internal.ResultContext;
import org.hibernate.result.internal.ResultSetOutputImpl;
import org.hibernate.result.internal.UpdateCountOutputImpl;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.internal.Helper;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.values.DirectResultSetAccess;
import org.hibernate.sql.results.internal.values.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.sql.results.spi.RowReader;
import org.jboss.logging.Logger;

public abstract class OutputsImpl
implements Outputs,
ExecutionContext,
DomainParameterBindingContext,
Callback {
    private static final Logger log = CoreLogging.logger(OutputsImpl.class);
    private final ResultContext context;
    private CurrentReturnState currentReturnState;
    private ResultSetMappingDescriptor currentResultSetMapping;
    private int currentResultSetMappingIndex = -1;

    public OutputsImpl(ResultContext context) {
        this.context = context;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.context.getSession().getSessionFactory();
    }

    protected void prime(PreparedStatement jdbcStatement) {
        try {
            boolean isResultSet = jdbcStatement.execute();
            this.currentReturnState = this.buildCurrentReturnState(isResultSet, jdbcStatement);
        }
        catch (SQLException e) {
            throw this.context.convertException(e, "Error calling CallableStatement.getMoreResults");
        }
    }

    protected CurrentReturnState buildCurrentReturnState(boolean isResultSet, PreparedStatement jdbcStatement) {
        int updateCount = -1;
        if (!isResultSet) {
            try {
                updateCount = jdbcStatement.getUpdateCount();
            }
            catch (SQLException e) {
                throw this.context.convertException(e, "Error calling CallableStatement.getUpdateCount");
            }
        }
        return this.buildCurrentReturnState(isResultSet, updateCount, jdbcStatement);
    }

    protected CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount, PreparedStatement jdbcStatement) {
        return new CurrentReturnState(isResultSet, updateCount, jdbcStatement);
    }

    @Override
    public Output getCurrent() {
        if (this.currentReturnState == null) {
            return null;
        }
        return this.currentReturnState.getOutput();
    }

    @Override
    public boolean goToNext() {
        if (this.currentReturnState == null) {
            return false;
        }
        if (this.currentReturnState.indicatesMoreOutputs()) {
            try {
                boolean isResultSet = this.nextResult();
                this.currentReturnState = this.buildCurrentReturnState(isResultSet);
            }
            catch (SQLException e) {
                throw this.context.convertException(e, "Error calling CallableStatement.getMoreResults");
            }
        }
        return this.currentReturnState != null && this.currentReturnState.indicatesMoreOutputs();
    }

    protected abstract CurrentReturnState buildCurrentReturnState(boolean var1) throws SQLException;

    protected abstract boolean nextResult() throws SQLException;

    private List extractCurrentResults(PreparedStatement jdbcStatement) {
        try {
            return this.extractResults(jdbcStatement.getResultSet(), jdbcStatement);
        }
        catch (SQLException e) {
            throw this.context.convertException(e, "Error calling CallableStatement.getResultSet");
        }
    }

    protected List extractResults(ResultSet resultSet, PreparedStatement jdbcStatement) {
        DirectResultSetAccess resultSetAccess = new DirectResultSetAccess(this.context.getSession(), jdbcStatement, resultSet);
        ResultSetMapping resultSetMapping = this.resolveResultSetMapping(resultSetAccess);
        JdbcValuesResultSetImpl jdbcValuesSource = new JdbcValuesResultSetImpl(resultSetAccess, null, this.context.getQueryOptions(), resultSetMapping, this.context);
        RowReader<Object[]> rowReader = Helper.createRowReader(this.getSessionFactory(), this, row -> row, jdbcValuesSource);
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return null;
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Serializable getEffectiveOptionalId() {
                return null;
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(this.context, processingOptions);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(jdbcValuesSourceProcessingState, this.context.getQueryOptions(), rowReader, jdbcValuesSource);
        try {
            ArrayList<Object[]> results = new ArrayList<Object[]>();
            while (rowProcessingState.next()) {
                results.add(rowReader.readRow(rowProcessingState, processingOptions));
                rowProcessingState.finishRowProcessing();
            }
            ArrayList<Object[]> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            throw this.context.convertException(e, "Error processing return rows");
        }
        finally {
            rowReader.finishUp(jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp();
            jdbcValuesSource.finishUp();
        }
    }

    private ResultSetMapping resolveResultSetMapping(DirectResultSetAccess resultSetAccess) {
        ++this.currentResultSetMappingIndex;
        if (this.context.getResultSetMappings() == null || this.context.getResultSetMappings().isEmpty()) {
            if (this.currentResultSetMapping == null) {
                this.currentResultSetMapping = new ResultSetMappingDescriptorUndefined();
            }
        } else {
            if (this.currentResultSetMappingIndex >= this.context.getResultSetMappings().size()) {
                throw new HibernateException("Needed ResultSetMapping for ResultSet #%s, but query defined only %s ResultSetMapping(s)");
            }
            this.currentResultSetMapping = this.context.getResultSetMappings().get(this.currentResultSetMappingIndex);
        }
        return this.currentResultSetMapping.resolve(resultSetAccess, this.getSessionFactory());
    }

    protected class CurrentReturnState {
        private final boolean isResultSet;
        private final int updateCount;
        private final PreparedStatement jdbcStatement;
        private Output rtn;

        public CurrentReturnState(boolean isResultSet, int updateCount, PreparedStatement jdbcStatement) {
            this.isResultSet = isResultSet;
            this.updateCount = updateCount;
            this.jdbcStatement = jdbcStatement;
        }

        public boolean indicatesMoreOutputs() {
            return this.isResultSet() || this.getUpdateCount() >= 0;
        }

        public boolean isResultSet() {
            return this.isResultSet;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public Output getOutput() {
            if (this.rtn == null) {
                this.rtn = this.buildOutput();
            }
            return this.rtn;
        }

        protected Output buildOutput() {
            if (log.isDebugEnabled()) {
                log.debugf("Building Return [isResultSet=%s, updateCount=%s, extendedReturn=%s", (Object)this.isResultSet(), (Object)this.getUpdateCount(), (Object)this.hasExtendedReturns());
            }
            if (this.isResultSet()) {
                return this.buildResultSetOutput(OutputsImpl.this.extractCurrentResults(this.jdbcStatement));
            }
            if (this.getUpdateCount() >= 0) {
                return this.buildUpdateCountOutput(this.updateCount);
            }
            if (this.hasExtendedReturns()) {
                return this.buildExtendedReturn();
            }
            throw new NoMoreOutputsException();
        }

        protected Output buildResultSetOutput(List list) {
            return new ResultSetOutputImpl(list);
        }

        protected Output buildResultSetOutput(Supplier<List> listSupplier) {
            return new ResultSetOutputImpl(listSupplier);
        }

        protected Output buildUpdateCountOutput(int updateCount) {
            return new UpdateCountOutputImpl(updateCount);
        }

        protected boolean hasExtendedReturns() {
            return false;
        }

        protected Output buildExtendedReturn() {
            throw new IllegalStateException("State does not define extended returns");
        }
    }
}

