/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public abstract class AbstractJdbcValueBinder<J>
implements JdbcValueBinder<J> {
    private static final String BIND_MSG_TEMPLATE = "binding parameter [%s] as [%s] - [%s]";
    private static final String NULL_BIND_MSG_TEMPLATE = "binding parameter [%s] as [%s] - [null]";
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    public AbstractJdbcValueBinder(JavaTypeDescriptor<J> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.sqlDescriptor = sqlDescriptor;
    }

    @Override
    public final void bind(PreparedStatement st, int parameterPosition, J value, ExecutionContext executionContext) throws SQLException {
        boolean traceEnabled = BINDING_LOGGER.isTraceEnabled();
        if (value == null) {
            if (traceEnabled) {
                BINDING_LOGGER.trace(String.format(NULL_BIND_MSG_TEMPLATE, parameterPosition, JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode())));
            }
            st.setNull(parameterPosition, this.sqlDescriptor.getJdbcTypeCode());
        } else {
            if (traceEnabled) {
                BINDING_LOGGER.trace(String.format(BIND_MSG_TEMPLATE, parameterPosition, JdbcTypeNameMapper.getTypeName(this.sqlDescriptor.getJdbcTypeCode()), this.getJavaDescriptor().extractLoggableRepresentation(value)));
            }
            this.doBind(st, parameterPosition, value, executionContext);
        }
    }

    @Override
    public final void bind(CallableStatement st, String parameterName, J value, ExecutionContext executionContext) throws SQLException {
        boolean traceEnabled = BINDING_LOGGER.isTraceEnabled();
        if (value == null) {
            if (traceEnabled) {
                BINDING_LOGGER.trace(String.format(NULL_BIND_MSG_TEMPLATE, parameterName, JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode())));
            }
            st.setNull(parameterName, this.sqlDescriptor.getJdbcTypeCode());
        } else {
            if (traceEnabled) {
                BINDING_LOGGER.trace(String.format(BIND_MSG_TEMPLATE, parameterName, JdbcTypeNameMapper.getTypeName(this.sqlDescriptor.getJdbcTypeCode()), this.getJavaDescriptor().extractLoggableRepresentation(value)));
            }
            this.doBind(st, parameterName, value, executionContext);
        }
    }

    protected abstract void doBind(PreparedStatement var1, int var2, J var3, ExecutionContext var4) throws SQLException;

    protected abstract void doBind(CallableStatement var1, String var2, J var3, ExecutionContext var4) throws SQLException;
}

